/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.creators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethod;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.IVFWriter;
import org.flasck.flas.compiler.jsgen.packaging.JSEnvironment;
import org.flasck.jvm.J;
import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.FieldInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.CantHappenException;

public class JSClass
implements JSClassCreator {
    private final JSEnvironment jse;
    private final NameOfThing name;
    private final JSMethod ctor;
    private boolean genJS = true;
    private NameOfThing baseClass;
    private String javaBase;
    private boolean isInterface;
    private final List<JSMethod> methods = new ArrayList<JSMethod>();
    private final List<Field> fields = new ArrayList<Field>();
    private final List<Field> ifields = new ArrayList<Field>();
    private final List<String> intfs = new ArrayList<String>();
    private boolean wantTypeNameClzVar;

    public JSClass(JSEnvironment jse, NameOfThing clz) {
        this.jse = jse;
        this.name = clz;
        this.ctor = this.classMethod(null);
    }

    @Override
    public void wantsTypeName() {
        this.wantTypeNameClzVar = true;
    }

    @Override
    public NameOfThing name() {
        return this.name;
    }

    public String clzname() {
        return this.name.jsName();
    }

    @Override
    public void notJS() {
        this.genJS = false;
    }

    @Override
    public boolean wantJS() {
        return this.genJS;
    }

    @Override
    public void inheritsFrom(NameOfThing baseClass, String javaName) {
        this.baseClass = baseClass;
        this.javaBase = javaName;
        if (this.baseClass != null) {
            this.ctor.inheritFrom(baseClass);
        }
    }

    @Override
    public void implementsJava(String clz) {
        this.intfs.add(clz);
    }

    @Override
    public void justAnInterface() {
        this.isInterface = true;
    }

    @Override
    public void field(boolean isStatic, JavaInfo.Access access, NameOfThing type, String var) {
        if (this.hasField(var)) {
            throw new CantHappenException("duplicate field " + var);
        }
        this.fields.add(new Field(isStatic, access, type, var, false, null));
    }

    @Override
    public void field(boolean isStatic, JavaInfo.Access access, NameOfThing type, String var, int value) {
        if (this.hasField(var)) {
            throw new CantHappenException("duplicate field " + var);
        }
        this.fields.add(new Field(isStatic, access, type, var, false, value));
    }

    @Override
    public void inheritsField(boolean isStatic, JavaInfo.Access access, NameOfThing type, String var) {
        if (this.hasField(var)) {
            throw new CantHappenException("duplicate field " + var);
        }
        this.ifields.add(new Field(isStatic, access, type, var, false, null));
    }

    @Override
    public boolean hasField(String var) {
        for (Field f : this.fields) {
            if (!f.var.equals(var)) continue;
            return true;
        }
        for (Field f : this.ifields) {
            if (!f.var.equals(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSMethodCreator createMethod(String name, boolean prototype) {
        JSMethod meth = new JSMethod(this.jse, null, this.name, prototype, name);
        this.methods.add(meth);
        return meth;
    }

    public JSMethod classMethod(String mname) {
        return new JSMethod(this.jse, null, this.name, false, mname);
    }

    @Override
    public JSMethodCreator constructor() {
        return this.ctor;
    }

    public void writeTo(Set<String> exports, IndentWriter iw) {
        if (!this.genJS) {
            return;
        }
        HashSet<NameOfThing> names = new HashSet<NameOfThing>();
        names.add(this.name);
        if (this.name.container() instanceof FunctionName) {
            JSMethod.ensureContainingNames(iw, this.name.container(), names);
        }
        this.ctor.write(iw, names, exports);
        if (this.baseClass != null) {
            iw.println(this.name.jsName() + ".prototype = new " + this.baseClass.jsName() + "();");
            iw.println(this.name.jsName() + ".prototype.constructor = " + this.name.jsName() + ";");
        }
        if (this.wantTypeNameClzVar) {
            iw.println("\n");
            iw.println(this.name.jsName() + "._typename = '" + this.name.uniqueName() + "'");
        }
        for (Field f : this.fields) {
            if (!f.isFinal || f.value == null) continue;
            iw.print(this.name.jsName() + "." + f.var + " = ");
            if (f.value instanceof Integer) {
                iw.print(Integer.toString((Integer)f.value));
            } else if (f.value instanceof String && f.isClassName) {
                iw.print((String)f.value);
            } else if (f.value instanceof String) {
                iw.print("'" + (String)f.value + "'");
            } else if (f.value != null) {
                throw new CantHappenException("value is a " + f.value.getClass());
            }
            iw.println(";");
        }
        for (JSMethod m : this.methods) {
            m.write(iw, names, exports);
        }
    }

    public void generate(ByteCodeEnvironment bce) {
        if (bce == null) {
            return;
        }
        ByteCodeCreator bcc = bce.newClass(this.name.javaName());
        if (this.isInterface) {
            bcc.makeInterface();
        }
        if (this.javaBase != null) {
            bcc.superclass(this.javaBase);
        } else if (this.baseClass != null) {
            bcc.superclass(this.baseClass.javaName());
        } else {
            bcc.superclass(J.OBJECT);
        }
        for (String s : this.intfs) {
            bcc.implementsInterface(s);
        }
        bcc.generateAssociatedSourceFile();
        for (Field f : this.fields) {
            FieldInfo fi = bcc.defineField(f.isFinal, f.access, f.type.javaName(), f.var);
            if (!f.isFinal || f.value == null) continue;
            if (f.value instanceof Integer) {
                fi.constValue(((Integer)f.value).intValue());
                continue;
            }
            if (f.value instanceof String) {
                fi.constValue((String)f.value);
                continue;
            }
            throw new CantHappenException("value is a " + f.value.getClass());
        }
        for (Field f : this.ifields) {
            bcc.inheritsField(f.isFinal, f.access, f.type.javaName(), f.var);
        }
        if (!this.isInterface) {
            this.ctor.generate(bce, false);
        }
        for (JSMethod m : this.methods) {
            m.generate(bce, this.isInterface);
        }
    }

    public String asivm() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        IVFWriter iw = new IVFWriter(pw);
        this.asivm(iw);
        return sw.toString();
    }

    private void asivm(IVFWriter iw) {
        iw.println("class " + this.name.uniqueName());
        if (this.ctor != null) {
            this.ctor.asivm(iw.indent());
        }
        for (JSMethod m : this.methods) {
            m.asivm(iw.indent());
        }
    }

    public String toString() {
        return "JSClass[" + this.name + "]";
    }

    public class Field {
        private final boolean isFinal;
        private final JavaInfo.Access access;
        private final NameOfThing type;
        private final String var;
        private final boolean isClassName;
        private final Object value;

        public Field(boolean isFinal, JavaInfo.Access access, NameOfThing type, String var, boolean isClassName, Object value) {
            this.isFinal = isFinal;
            this.access = access;
            this.type = type;
            this.var = var;
            this.isClassName = isClassName;
            this.value = value;
        }
    }
}

