/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.creators;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.JavaMethodNameProvider;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.UnitTestName;
import org.flasck.flas.compiler.jsgen.creators.JSBlock;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSLiteral;
import org.flasck.flas.compiler.jsgen.form.JSString;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.flasck.flas.hsi.Slot;
import org.flasck.jvm.J;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.GenericAnnotator;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.IFieldInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.Var;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class BasicJVMCreationContext
implements JVMCreationContext {
    private final ByteCodeSink bcc;
    private final NewMethodDefiner md;
    private final IExpr runner;
    private Var cxt;
    private final Var args;
    private final Map<JSExpr, IExpr> vars = new HashMap<JSExpr, IExpr>();
    private final Map<JSExpr, IExpr> stack = new HashMap<JSExpr, IExpr>();
    private final Map<Slot, IExpr> slots = new HashMap<Slot, IExpr>();
    private final Map<JSBlockCreator, IExpr> blocks = new HashMap<JSBlockCreator, IExpr>();
    private final boolean isCtor;

    public BasicJVMCreationContext(ByteCodeEnvironment bce, UnitTestName fnName, List<JSVar> as) {
        this.bcc = bce.newClass(fnName.javaName());
        this.bcc.generateAssociatedSourceFile();
        this.isCtor = false;
        GenericAnnotator ann = GenericAnnotator.newMethod((ByteCodeSink)this.bcc, (boolean)true, (String)"dotest");
        GenericAnnotator.PendingVar r1 = ann.argument(J.TESTHELPER, "runner");
        GenericAnnotator.PendingVar c1 = ann.argument(J.FLEVALCONTEXT, "cxt");
        ann.returns(JavaType.void_);
        this.md = ann.done();
        this.cxt = c1.getVar();
        this.args = null;
        this.runner = r1.getVar();
        this.vars.put(as.get(0), this.runner);
    }

    public BasicJVMCreationContext(ByteCodeEnvironment bce, NameOfThing clzName, List<JSVar> as, List<JSExpr> superArgs) {
        this.bcc = bce.get(clzName.javaName());
        this.bcc.generateAssociatedSourceFile();
        this.isCtor = true;
        GenericAnnotator ann = GenericAnnotator.newConstructor((ByteCodeSink)this.bcc, (boolean)false);
        GenericAnnotator.PendingVar c1 = null;
        GenericAnnotator.PendingVar r1 = null;
        HashMap<JSVar, GenericAnnotator.PendingVar> tmp = new HashMap<JSVar, GenericAnnotator.PendingVar>();
        for (JSVar jSVar : as) {
            GenericAnnotator.PendingVar ai = ann.argument(jSVar.type(), jSVar.asVar());
            tmp.put(jSVar, ai);
            if (jSVar.asVar().equals("_cxt")) {
                c1 = ai;
                continue;
            }
            if (!jSVar.asVar().equals("runner")) continue;
            r1 = ai;
        }
        this.md = ann.done();
        if (c1 != null) {
            this.cxt = c1.getVar();
        }
        this.runner = r1 != null ? r1.getVar() : null;
        for (Map.Entry entry : tmp.entrySet()) {
            this.vars.put((JSExpr)entry.getKey(), (IExpr)((GenericAnnotator.PendingVar)entry.getValue()).getVar());
        }
        this.args = null;
        IExpr[] sas = new IExpr[superArgs.size()];
        boolean bl = false;
        for (JSExpr jv : superArgs) {
            if (jv instanceof JSVar) {
                sas[var10_14++] = this.vars.get(jv);
                continue;
            }
            jv.generate(this);
            sas[var10_14++] = this.argAsIs(jv);
        }
        this.md.callSuper("void", this.bcc.getSuperClass(), "<init>", sas).flush();
    }

    public BasicJVMCreationContext(ByteCodeEnvironment bce, NameOfThing clzName, String name, NameOfThing fnName, boolean wantArgumentList, List<JSVar> as, JSExpr runner, String returnsA) {
        this(BasicJVMCreationContext.figureMemberClassThings(bce, clzName, name, fnName, returnsA), wantArgumentList, as, runner);
    }

    private static MethodCxt figureMemberClassThings(ByteCodeEnvironment bce, NameOfThing clzName, String name, NameOfThing fnName, String returnsA) {
        MethodCxt ret = new MethodCxt();
        ret.returnsA = returnsA;
        if (fnName == null) {
            ret.bcc = bce.getOrCreate(clzName.javaName());
            ret.ann = GenericAnnotator.newMethod((ByteCodeSink)ret.bcc, (boolean)false, (String)name);
        } else {
            ret.bcc = bce.getOrCreate(fnName.javaClassName());
            ret.ann = GenericAnnotator.newMethod((ByteCodeSink)ret.bcc, (boolean)false, (String)((JavaMethodNameProvider)((Object)fnName)).javaMethodName());
        }
        return ret;
    }

    public BasicJVMCreationContext(ByteCodeEnvironment bce, NameOfThing clzName, String name, NameOfThing fnName, boolean wantArgumentList, List<JSVar> as, JSExpr runner, String returnType, Object isStatic) {
        this(BasicJVMCreationContext.figureStaticClassThings(bce, fnName, clzName, name, as.size() - 1, returnType), wantArgumentList, as, runner);
    }

    private static MethodCxt figureStaticClassThings(ByteCodeEnvironment bce, NameOfThing fnName, NameOfThing clzName, String name, int nfargs, String returnType) {
        MethodCxt ret = new MethodCxt();
        ret.returnsA = returnType;
        ret.bcc = fnName == null ? bce.getOrCreate(clzName.javaName()) : bce.getOrCreate(fnName.javaName());
        ret.bcc.generateAssociatedSourceFile();
        Object fieldName = fnName != null || name.equals("eval") ? "nfargs" : name + "_nfargs";
        IFieldInfo fi = ret.bcc.defineField(true, JavaInfo.Access.PUBLICSTATIC, JavaType.int_, (String)fieldName);
        fi.constValue(nfargs);
        ret.ann = GenericAnnotator.newMethod((ByteCodeSink)ret.bcc, (boolean)true, (String)(fnName != null || name == null ? "eval" : name));
        return ret;
    }

    private BasicJVMCreationContext(MethodCxt mc, boolean wantArgumentList, List<JSVar> as, JSExpr runner) {
        this.bcc = mc.bcc;
        this.isCtor = false;
        GenericAnnotator.PendingVar c1 = null;
        GenericAnnotator.PendingVar a1 = null;
        HashMap<JSVar, GenericAnnotator.PendingVar> tmp = new HashMap<JSVar, GenericAnnotator.PendingVar>();
        if (wantArgumentList) {
            c1 = mc.ann.argument(J.FLEVALCONTEXT, "cxt");
            a1 = mc.ann.argument("[" + J.OBJECT, "args");
        } else {
            for (JSVar jSVar : as) {
                GenericAnnotator.PendingVar ai = mc.ann.argument(jSVar.type(), jSVar.asVar());
                tmp.put(jSVar, ai);
                if (!jSVar.asVar().equals("_cxt")) continue;
                c1 = ai;
            }
        }
        mc.ann.returns(mc.returnsA);
        this.md = mc.ann.done();
        Var var = this.cxt = c1 == null ? null : c1.getVar();
        if (wantArgumentList) {
            this.args = a1.getVar();
            for (int ap = 1; ap < as.size(); ++ap) {
                JSVar jSVar = as.get(ap);
                this.stack.put(jSVar, this.md.arrayElt((IExpr)this.args, this.md.intConst(ap - 1)));
            }
        } else {
            this.args = null;
            for (Map.Entry entry : tmp.entrySet()) {
                this.vars.put((JSExpr)entry.getKey(), (IExpr)((GenericAnnotator.PendingVar)entry.getValue()).getVar());
            }
        }
        if (runner != null) {
            this.runner = this.md.getField("_runner");
            this.vars.put(new JSVar("_runner"), this.runner);
        } else {
            this.runner = null;
        }
    }

    private BasicJVMCreationContext(ByteCodeSink bcc, NewMethodDefiner md, IExpr runner, Var cxt, Var args) {
        this.bcc = bcc;
        this.isCtor = false;
        this.md = md;
        this.runner = runner;
        if (runner != null) {
            this.vars.put(new JSVar("_runner"), this.runner);
        }
        this.cxt = cxt;
        this.args = args;
    }

    @Override
    public void version(int vno) {
        this.bcc.version(vno);
    }

    @Override
    public JVMCreationContext split() {
        BasicJVMCreationContext ret = new BasicJVMCreationContext(this.bcc, this.md, this.runner, this.cxt, this.args);
        ret.vars.putAll(this.vars);
        ret.stack.putAll(this.stack);
        ret.slots.putAll(this.slots);
        ret.blocks.putAll(this.blocks);
        return ret;
    }

    @Override
    public ByteCodeSink clazz() {
        return this.bcc;
    }

    @Override
    public NewMethodDefiner method() {
        return this.md;
    }

    @Override
    public IExpr helper() {
        return this.runner;
    }

    @Override
    public IExpr cxt() {
        return this.cxt;
    }

    @Override
    public void setCxt(Var cxt) {
        this.cxt = cxt;
    }

    @Override
    public Var fargs() {
        return this.args;
    }

    @Override
    public boolean isCtor() {
        return this.isCtor;
    }

    @Override
    public void bindVar(JSExpr local, Var v) {
        this.vars.put(local, (IExpr)v);
    }

    @Override
    public boolean hasLocal(JSExpr key) {
        return this.stack.containsKey(key);
    }

    @Override
    public void local(JSExpr key, IExpr e) {
        if (key == null) {
            throw new CantHappenException("cannot have key be null");
        }
        if (this.stack.containsKey(key)) {
            throw new CantHappenException("duplicate entry for: " + key);
        }
        this.stack.put(key, e);
    }

    @Override
    public void block(JSBlock key, List<IExpr> blk) {
        this.blocks.put(key, this.md.block(blk.toArray(new IExpr[blk.size()])));
    }

    @Override
    public String figureName(NameOfThing fn) {
        Object push = null;
        if (fn.container() instanceof PackageName && ((PackageName)fn.container()).isBuiltin()) {
            push = this.resolveOpName(fn.baseName());
            if (push == null) {
                push = fn instanceof FunctionName ? "org.flasck.jvm.builtin.PACKAGEFUNCTIONS." + fn.baseName() : "org.flasck.jvm.builtin." + fn.baseName();
            }
        } else {
            push = fn.javaName();
        }
        return push;
    }

    @Override
    public IExpr stmt(JSExpr stmt) {
        if (!this.stack.containsKey(stmt)) {
            throw new NotImplementedException("there is nothing in the stack for " + stmt);
        }
        return this.stack.get(stmt);
    }

    @Override
    public IExpr arg(JSExpr jsExpr) {
        IExpr a = this.argAsIs(jsExpr);
        if (a == null) {
            return null;
        }
        return this.md.as(a, J.OBJECT);
    }

    @Override
    public IExpr argAs(JSExpr jsExpr, JavaType type) {
        IExpr a = this.argAsIs(jsExpr);
        if (a == null) {
            return null;
        }
        return this.md.as(a, type.getActual());
    }

    @Override
    public IExpr argAsIs(JSExpr jsExpr) {
        if (this.vars.containsKey(jsExpr)) {
            return this.vars.get(jsExpr);
        }
        if (this.stack.containsKey(jsExpr)) {
            return this.stack.get(jsExpr);
        }
        if (jsExpr instanceof JSLiteral) {
            JSLiteral l = (JSLiteral)jsExpr;
            l.generate(this);
            return this.stack.get(l);
        }
        if (jsExpr instanceof JSString) {
            JSString l = (JSString)jsExpr;
            if (l.value() == null) {
                return this.md.as(this.md.aNull(), J.STRING);
            }
            return this.md.stringConst(l.value());
        }
        jsExpr.generate(this);
        if (this.stack.containsKey(jsExpr)) {
            return this.stack.get(jsExpr);
        }
        throw new NotImplementedException("there is no var for " + jsExpr.getClass() + " " + jsExpr);
    }

    @Override
    public IExpr blk(JSBlockCreator blk) {
        if (!this.blocks.containsKey(blk)) {
            throw new NotImplementedException("there is no block " + blk);
        }
        return this.blocks.get(blk);
    }

    @Override
    public void done(JSBlockCreator blk) {
        this.blk(blk).flush();
    }

    private String resolveOpName(String op) {
        String inner;
        switch (op) {
            case "&&": {
                inner = "And";
                break;
            }
            case "||": {
                inner = "Or";
                break;
            }
            case "!": {
                inner = "Not";
                break;
            }
            case "==": {
                inner = "IsEqual";
                break;
            }
            case ">=": {
                inner = "GreaterEqual";
                break;
            }
            case ">": {
                inner = "GreaterThan";
                break;
            }
            case "<=": {
                inner = "LessEqual";
                break;
            }
            case "<": {
                inner = "LessThan";
                break;
            }
            case "+": {
                inner = "Plus";
                break;
            }
            case "-": {
                inner = "Minus";
                break;
            }
            case "*": {
                inner = "Mul";
                break;
            }
            case "/": {
                inner = "Div";
                break;
            }
            case "%": {
                inner = "Mod";
                break;
            }
            case "++": {
                inner = "strAppend";
                break;
            }
            case "[]": {
                return J.NIL;
            }
            case "()": {
                return "MakeTuple";
            }
            case "{}": {
                inner = "MakeHash";
                break;
            }
            case ":": {
                inner = "hashPair";
                break;
            }
            default: {
                return null;
            }
        }
        return "org.flasck.jvm.builtin.PACKAGEFUNCTIONS." + inner;
    }

    static class MethodCxt {
        ByteCodeSink bcc;
        GenericAnnotator ann;
        String returnsA;

        MethodCxt() {
        }
    }
}

