/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.CaptureAssertionClauseVisitorJS;
import org.flasck.flas.compiler.jsgen.CloseCardVisitorJS;
import org.flasck.flas.compiler.jsgen.DoExpectationCancelGeneratorJS;
import org.flasck.flas.compiler.jsgen.DoExpectationGeneratorJS;
import org.flasck.flas.compiler.jsgen.DoInvocationGeneratorJS;
import org.flasck.flas.compiler.jsgen.DoSendGeneratorJS;
import org.flasck.flas.compiler.jsgen.DoUTEventGeneratorJS;
import org.flasck.flas.compiler.jsgen.DoUTInputGeneratorJS;
import org.flasck.flas.compiler.jsgen.DoUTMatchGeneratorJS;
import org.flasck.flas.compiler.jsgen.DoUTRenderGeneratorJS;
import org.flasck.flas.compiler.jsgen.HandleShoveClauseVisitorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.JSFunctionStateStore;
import org.flasck.flas.compiler.jsgen.SharesState;
import org.flasck.flas.compiler.jsgen.SystemTestModule;
import org.flasck.flas.compiler.jsgen.UDDGeneratorJS;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.packaging.JSStorage;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.ut.UnitTestAssert;
import org.flasck.flas.parsedForm.ut.UnitTestClose;
import org.flasck.flas.parsedForm.ut.UnitTestEvent;
import org.flasck.flas.parsedForm.ut.UnitTestExpect;
import org.flasck.flas.parsedForm.ut.UnitTestExpectCancel;
import org.flasck.flas.parsedForm.ut.UnitTestIdentical;
import org.flasck.flas.parsedForm.ut.UnitTestInput;
import org.flasck.flas.parsedForm.ut.UnitTestInvoke;
import org.flasck.flas.parsedForm.ut.UnitTestMatch;
import org.flasck.flas.parsedForm.ut.UnitTestNewDiv;
import org.flasck.flas.parsedForm.ut.UnitTestRender;
import org.flasck.flas.parsedForm.ut.UnitTestSend;
import org.flasck.flas.parsedForm.ut.UnitTestShove;
import org.flasck.flas.parsedForm.ut.UnitTestStep;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.jvm.J;
import org.zinutils.bytecode.JavaInfo;

public class UnitTestStepGenerator
extends LeafAdapter
implements SharesState {
    private final NestedVisitor sv;
    private final JSClassCreator clz;
    private final JSFunctionState ostate;
    private final JSExpr runner;
    private final Set<UnitDataDeclaration> globalMocks;
    private final List<JSExpr> parentExplodingMocks;
    private final List<JSExpr> explodingMocks;
    private final JSMethodCreator meth;
    private final JSFunctionState state;
    private final JSBlockCreator block;
    private final TreeMap<UnitDataDeclaration, JSExpr> mocks;
    private final TreeMap<IntroduceVar, JSExpr> introductions;
    private final HashMap<NameOfThing, JSExpr> containers;
    private final String baseName;

    public UnitTestStepGenerator(NestedVisitor sv, JSStorage jse, JSClassCreator clz, JSMethodCreator meth, JSFunctionState state, JSBlockCreator block, JSExpr runner, Set<UnitDataDeclaration> globalMocks, List<JSExpr> explodingMocks, boolean includeJs, NameOfThing testName, int stepNum) {
        this.sv = sv;
        this.clz = clz;
        this.ostate = state;
        this.runner = runner;
        this.globalMocks = globalMocks;
        this.parentExplodingMocks = explodingMocks;
        this.explodingMocks = new ArrayList<JSExpr>();
        if (sv != null) {
            sv.push(this);
        }
        if (testName != null) {
            this.baseName = testName.baseName() + "_step_" + stepNum;
            this.meth = clz.createMethod(this.baseName, true);
            this.meth.argument(J.FLEVALCONTEXT, "_cxt");
            this.meth.returnsType("void");
            this.meth.helper(runner);
            this.block = this.meth;
            if (!includeJs) {
                this.meth.noJS();
            }
        } else {
            this.baseName = null;
            this.meth = meth;
            this.block = meth;
        }
        this.mocks = new TreeMap<UnitDataDeclaration, JSExpr>(this.ostate.mocks());
        this.introductions = new TreeMap(IntroduceVar.comparator);
        this.introductions.putAll(this.ostate.introductions());
        this.containers = new HashMap();
        this.containers.putAll(this.ostate.containers());
        this.state = new JSFunctionStateStore(this.meth, this.mocks, this.introductions, this.containers, this.ostate.moduleCaches());
    }

    public JSBlockCreator method() {
        return this.meth;
    }

    @Override
    public void shareWith(SystemTestModule module) {
        module.inject(null, this.clz, this.meth, this.state, this.block, this.runner);
    }

    @Override
    public void visitUnitDataDeclaration(UnitDataDeclaration udd) {
        UDDGeneratorJS.handleUDD(this.sv, this.meth, this.state, this.block, this.globalMocks, this.explodingMocks, udd);
    }

    @Override
    public void visitUnitTestAssert(UnitTestAssert a) {
        new CaptureAssertionClauseVisitorJS(this.state, this.sv, this.block, this.runner, "assertSameValue");
    }

    @Override
    public void visitUnitTestIdentical(UnitTestIdentical a) {
        new CaptureAssertionClauseVisitorJS(this.state, this.sv, this.block, this.runner, "assertIdentical");
    }

    @Override
    public void visitUnitTestShove(UnitTestShove a) {
        new HandleShoveClauseVisitorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestExpect(UnitTestExpect ute) {
        new DoExpectationGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitUnitTestClose(UnitTestClose s) {
        new CloseCardVisitorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestExpectCancel(UnitTestExpectCancel ute) {
        new DoExpectationCancelGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitUnitTestInvoke(UnitTestInvoke uti) {
        new DoInvocationGeneratorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestSend(UnitTestSend uts) {
        new DoSendGeneratorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestRender(UnitTestRender e) {
        new DoUTRenderGeneratorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestEvent(UnitTestEvent ute) {
        new DoUTEventGeneratorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestInput(UnitTestInput ute) {
        new DoUTInputGeneratorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestMatch(UnitTestMatch m) {
        new DoUTMatchGeneratorJS(this.state, this.sv, this.block, this.runner);
    }

    @Override
    public void visitUnitTestNewDiv(UnitTestNewDiv s) {
        this.block.newdiv(s.cnt);
    }

    @Override
    public void leaveUnitTestStep(UnitTestStep s) {
        TreeMap<UnitDataDeclaration, JSExpr> asfields = new TreeMap<UnitDataDeclaration, JSExpr>((SortedMap<UnitDataDeclaration, JSExpr>)this.mocks);
        HashMap<JSExpr, JSExpr> mapmocks = new HashMap<JSExpr, JSExpr>();
        for (Map.Entry entry : asfields.entrySet()) {
            if (this.ostate.mocks().containsKey(entry.getKey())) continue;
            String mn = "_mock_" + ((UnitDataDeclaration)entry.getKey()).name.baseName();
            this.clz.field(false, JavaInfo.Access.PRIVATE, new PackageName(J.OBJECT), mn);
            this.meth.setField(false, mn, (JSExpr)entry.getValue());
            JSExpr fm = this.meth.field(mn);
            this.ostate.mocks().put((UnitDataDeclaration)entry.getKey(), fm);
            mapmocks.put((JSExpr)entry.getValue(), fm);
        }
        for (JSExpr jSExpr : this.explodingMocks) {
            this.parentExplodingMocks.add((JSExpr)mapmocks.get(jSExpr));
        }
        TreeMap<IntroduceVar, JSExpr> asflds = new TreeMap<IntroduceVar, JSExpr>((SortedMap<IntroduceVar, JSExpr>)this.introductions);
        for (Map.Entry<IntroduceVar, JSExpr> e : asflds.entrySet()) {
            if (this.ostate.introductions().containsKey(e.getKey())) continue;
            String bn = "_iv_" + e.getKey().var;
            if (!this.clz.hasField(bn)) {
                this.clz.field(false, JavaInfo.Access.PRIVATE, new PackageName(J.OBJECT), bn);
            }
            this.meth.setField(false, bn, e.getValue());
            this.ostate.introductions().put(e.getKey(), this.meth.field(bn));
        }
        if (s != null) {
            this.block.returnVoid();
        }
        if (this.sv != null) {
            this.sv.result(null);
        }
    }

    public String name() {
        return this.baseName;
    }

    public void assertSatisfied(JSExpr m) {
        this.state.meth().assertSatisfied(m);
    }
}

