/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.List;
import java.util.Set;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.names.CardName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.compiler.jsgen.ExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ServiceDefinition;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;

public class UDDGeneratorJS
extends LeafAdapter
implements ResultAware {
    private final NestedVisitor sv;
    private final JSMethodCreator meth;
    private final JSFunctionState state;
    private final JSBlockCreator block;
    private JSExpr assigned;
    private boolean assigning;

    public UDDGeneratorJS(NestedVisitor sv, JSMethodCreator meth, JSFunctionState state, JSBlockCreator block) {
        this.sv = sv;
        this.meth = meth;
        this.state = state;
        this.block = block;
        sv.push(this);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        new ExprGeneratorJS(this.state, this.sv, this.block, false);
    }

    @Override
    public void visitUnitDataField(UnitDataDeclaration.Assignment assign) {
        this.assigning = true;
    }

    @Override
    public void result(Object r) {
        if (!this.assigning) {
            this.assigned = (JSExpr)r;
        }
    }

    @Override
    public void leaveUnitDataDeclaration(UnitDataDeclaration udd) {
        JSExpr value = this.assigned != null ? this.assigned : this.meth.createObject(udd.ofType.namedDefn().name());
        JSExpr newMock = this.block.storeMockObject(udd, value);
        this.state.addMock(udd, newMock);
        this.sv.result(null);
    }

    public static void handleUDD(NestedVisitor sv, JSMethodCreator meth, JSFunctionState state, JSBlockCreator block, Set<UnitDataDeclaration> globalMocks, List<JSExpr> explodingMocks, UnitDataDeclaration udd) {
        if (meth == null) {
            globalMocks.add(udd);
            return;
        }
        NamedType objty = udd.ofType.namedDefn();
        if (objty instanceof PolyInstance) {
            objty = ((PolyInstance)objty).struct();
        }
        if (objty instanceof ContractDecl) {
            JSExpr mock;
            ContractDecl cd = (ContractDecl)objty;
            if (cd.type == ContractDecl.ContractType.HANDLER) {
                if (udd.expr != null) {
                    new UDDGeneratorJS(sv, meth, state, block);
                    return;
                }
                mock = meth.mockHandler((SolidName)objty.name());
            } else {
                mock = meth.mockContract((SolidName)objty.name());
            }
            state.addMock(udd, mock);
            explodingMocks.add(mock);
        } else if (objty instanceof AgentDefinition) {
            JSExpr obj = meth.createAgent((CardName)objty.name());
            state.addMock(udd, obj);
        } else if (objty instanceof CardDefinition) {
            JSExpr obj = meth.createCard((CardName)objty.name());
            state.addMock(udd, obj);
        } else if (objty instanceof ServiceDefinition) {
            JSExpr obj = meth.createService((CardName)objty.name());
            state.addMock(udd, obj);
        } else if (objty instanceof StructDefn || objty instanceof UnionTypeDefn) {
            new UDDGeneratorJS(sv, meth, state, block);
        } else if (objty instanceof ObjectDefn) {
            new UDDGeneratorJS(sv, meth, state, block);
        } else if (objty instanceof HandlerImplements) {
            new UDDGeneratorJS(sv, meth, state, block);
        } else {
            throw new RuntimeException("not handled: " + objty + " of " + objty.getClass());
        }
    }
}

