/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.compiler.jsgen.ApplyExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.ExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSTypeOf;
import org.flasck.flas.parsedForm.TypeExpr;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.zinutils.exceptions.CantHappenException;

public class TypeExprGeneratorJS
extends LeafAdapter
implements ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private final JSBlockCreator block;
    private JSTypeOf expr;

    public TypeExprGeneratorJS(JSFunctionState state, NestedVisitor sv, JSBlockCreator block) {
        this.state = state;
        this.sv = sv;
        this.block = block;
        sv.push(this);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        if (expr instanceof TypeReference) {
            return;
        }
        if (expr instanceof MemberExpr && ((MemberExpr)expr).boundEarly() && ((MemberExpr)expr).defn() instanceof TypeReference) {
            return;
        }
        ExprGeneratorJS ej = new ExprGeneratorJS(this.state, this.sv, this.block, false);
        ej.visitExpr(expr, nArgs);
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (!expr.boundEarly()) {
            throw new CantHappenException("I think our test above should stop this happening");
        }
        TypeReference tr = (TypeReference)((Object)expr.defn());
        this.expr = new JSTypeOf(tr.namedDefn());
        return true;
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        this.expr = new JSTypeOf(var.namedDefn());
    }

    @Override
    public void visitTypeExpr(TypeExpr expr) {
        new TypeExprGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitApplyExpr(ApplyExpr expr) {
        new ApplyExprGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void result(Object r) {
        if (this.expr != null) {
            throw new CantHappenException("set expr twice");
        }
        this.expr = new JSTypeOf((JSExpr)r);
    }

    @Override
    public void leaveTypeExpr(TypeExpr expr) {
        if (this.expr == null) {
            throw new CantHappenException("we didn't consider some (type ...) case");
        }
        this.sv.result(this.expr);
    }
}

