/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.ExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.JSStyleIf;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;

public class TemplateStylingJS
extends LeafAdapter
implements ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private final JSBlockCreator currentBlock;
    private final List<JSExpr> exprs = new ArrayList<JSExpr>();
    private List<JSExpr> elseExprs = null;
    private JSExpr cond;
    private Mode mode;
    private List<JSStyleIf> styles = new ArrayList<JSStyleIf>();

    public TemplateStylingJS(JSFunctionState state, NestedVisitor sv, JSBlockCreator currentBlock, TemplateStylingOption tso) {
        this.state = state;
        this.sv = sv;
        this.currentBlock = currentBlock;
        sv.push(this);
    }

    @Override
    public void visitTemplateStyling(TemplateStylingOption tso) {
        this.mode = Mode.NESTED;
        new TemplateStylingJS(this.state, this.sv, this.currentBlock, tso);
    }

    @Override
    public void visitTemplateStyleCond(Expr cond) {
        this.mode = Mode.COND;
        new ExprGeneratorJS(this.state, this.sv, this.currentBlock, false);
    }

    @Override
    public void visitTemplateStyleExpr(Expr expr) {
        if (this.mode != Mode.ELSE) {
            this.mode = Mode.EXPR;
        }
        new ExprGeneratorJS(this.state, this.sv, this.currentBlock, false);
    }

    @Override
    public void visitTemplateStylesElse(TemplateStylingOption tso) {
        this.mode = Mode.ELSE;
        this.elseExprs = new ArrayList<JSExpr>();
    }

    @Override
    public void result(Object r) {
        if (this.mode == Mode.COND) {
            this.cond = (JSExpr)r;
        } else if (this.mode == Mode.EXPR) {
            this.exprs.add((JSExpr)r);
        } else if (this.mode == Mode.ELSE) {
            this.elseExprs.add((JSExpr)r);
        } else {
            List lsi = (List)r;
            for (JSStyleIf si : lsi) {
                if (this.cond == null) {
                    this.styles.add(si);
                    continue;
                }
                JSExpr doAnd = this.cond;
                if (si.cond != null) {
                    doAnd = this.currentBlock.closure(false, this.currentBlock.pushFunction("FLBuiltin.boolAnd", FunctionName.function(null, null, "And"), -1), this.cond, si.cond);
                }
                this.styles.add(new JSStyleIf(doAnd, si.style));
            }
        }
    }

    @Override
    public void leaveTemplateStyling(TemplateStylingOption tso) {
        this.styles.add(0, new JSStyleIf(this.cond, this.styleIf(tso.strings(), this.exprs)));
        if (this.elseExprs != null) {
            this.styles.add(0, new JSStyleIf(this.notOf(this.cond), this.styleIf(tso.elseStrings(), this.elseExprs)));
        }
        this.sv.result(this.styles);
    }

    private JSExpr notOf(JSExpr c) {
        return this.currentBlock.closure(false, this.currentBlock.pushFunction("FLBuiltin.not", FunctionName.function(null, null, "Not"), -1), this.cond);
    }

    private JSExpr styleIf(String c, List<JSExpr> es) {
        JSExpr ret;
        if (es.isEmpty()) {
            ret = this.currentBlock.string(c == null ? "" : c);
        } else {
            if (c != null) {
                es.add(0, this.currentBlock.string(c));
            }
            ret = this.currentBlock.closure(false, this.currentBlock.callStatic(FunctionName.function(null, new PackageName("FLBuiltin"), "concatMany"), 1), this.currentBlock.makeArray(es));
        }
        return ret;
    }

    public static enum Mode {
        COND,
        EXPR,
        ELSE,
        NESTED;

    }
}

