/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.JSStyleIf;
import org.flasck.flas.compiler.jsgen.TemplateBindingProcessorJS;
import org.flasck.flas.compiler.jsgen.TemplateStylingJS;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;

public class TemplateProcessorJS
extends LeafAdapter
implements ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private final JSClassCreator templateCreator;
    private final AtomicInteger containerIdx;
    private final JSBlockCreator templateBlock;
    private final JSExpr source;
    private final Template t;
    private final List<JSStyleIf> styles = new ArrayList<JSStyleIf>();
    private final List<JSExpr> cexpr = new ArrayList<JSExpr>();
    private boolean hasStylingEvents = false;

    public TemplateProcessorJS(JSFunctionState state, NestedVisitor sv, JSClassCreator templateCreator, AtomicInteger containerIdx, JSBlockCreator currentBlock, JSExpr source, Template t) {
        this.state = state;
        this.sv = sv;
        this.templateCreator = templateCreator;
        this.containerIdx = containerIdx;
        this.templateBlock = currentBlock;
        this.source = source;
        this.t = t;
        sv.push(this);
    }

    @Override
    public void visitTemplateBinding(TemplateBinding b) {
        new TemplateBindingProcessorJS(this.state, this.sv, this.templateCreator, this.containerIdx, this.templateBlock, this.t, this.source, b);
    }

    @Override
    public void visitTemplateStyling(TemplateStylingOption tso) {
        new TemplateStylingJS(this.state, this.sv, this.templateBlock, tso);
    }

    @Override
    public void result(Object r) {
        if (r instanceof List) {
            List lsi = (List)r;
            for (JSStyleIf si : lsi) {
                if (si.cond != null) {
                    this.styles.add(si);
                    continue;
                }
                this.cexpr.add(si.style);
            }
        }
    }

    @Override
    public void leaveTemplate(Template t) {
        TemplateBindingProcessorJS.applyStyles(this.templateBlock, t.webinfo().id(), null, 0, this.source, this.styles, this.cexpr, this.hasStylingEvents);
        this.templateBlock.returnVoid();
        this.sv.result(null);
    }
}

