/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.ExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.JSStyleIf;
import org.flasck.flas.compiler.jsgen.TemplateStylingJS;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.creators.JSIfCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSLoadField;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateCustomization;
import org.flasck.flas.parsedForm.TemplateField;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.NamedType;
import org.flasck.jvm.J;
import org.ziniki.splitter.FieldType;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.exceptions.NotImplementedException;

public class TemplateBindingProcessorJS
extends LeafAdapter
implements ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private final String templateName;
    private final JSClassCreator templateCreator;
    private final AtomicInteger containerIdx;
    private final TemplateBinding b;
    private final JSExpr source;
    private final List<JSStyleIf> styles = new ArrayList<JSStyleIf>();
    private final List<JSExpr> cexpr = new ArrayList<JSExpr>();
    private Mode mode;
    private JSIfCreator ie;
    private JSBlockCreator bindingBlock;
    private TemplateBindingOption currentTBO;
    private int option = 0;

    public TemplateBindingProcessorJS(JSFunctionState state, NestedVisitor sv, JSClassCreator templateCreator, AtomicInteger containerIdx, JSBlockCreator templateBlock, Template t, JSExpr source, TemplateBinding b) {
        this.state = state;
        this.sv = sv;
        this.source = source;
        this.templateName = t.webinfo().id();
        this.templateCreator = templateCreator;
        this.containerIdx = containerIdx;
        this.bindingBlock = templateBlock;
        this.b = b;
        sv.push(this);
    }

    @Override
    public void visitTemplateBindingOption(TemplateBindingOption option) {
        this.currentTBO = option;
        ++this.option;
    }

    @Override
    public void visitTemplateBindingCondition(Expr cond) {
        this.mode = Mode.COND;
        new ExprGeneratorJS(this.state, this.sv, this.bindingBlock, false);
    }

    @Override
    public void visitTemplateBindingExpr(Expr expr) {
        this.mode = Mode.EXPR;
        new ExprGeneratorJS(this.state, this.sv, this.bindingBlock, false);
    }

    @Override
    public void visitTemplateStyling(TemplateStylingOption tso) {
        new TemplateStylingJS(this.state, this.sv, this.bindingBlock, tso);
    }

    @Override
    public void result(Object r) {
        if (r instanceof List) {
            List lsi = (List)r;
            for (JSStyleIf si : lsi) {
                if (si.cond != null) {
                    this.styles.add(si);
                    continue;
                }
                this.cexpr.add(si.style);
            }
        } else if (this.mode == Mode.COND) {
            this.ie = this.bindingBlock.ifTrue((JSExpr)r);
            this.bindingBlock = this.ie.trueCase();
        } else if (this.currentTBO.sendsTo != null) {
            ArrayList<JSExpr> wanted = new ArrayList<JSExpr>();
            if (this.state.templateObj() != null) {
                for (int i : this.currentTBO.sendsTo.contextPosns()) {
                    wanted.add((JSExpr)CollectionUtils.nth(this.state.templateObj().values(), (int)i));
                }
            }
            boolean isOtherObject = this.currentTBO.expr instanceof UnresolvedVar && ((UnresolvedVar)this.currentTBO.expr).defn() instanceof StructField && ((StructField)((UnresolvedVar)this.currentTBO.expr).defn()).type.namedDefn() instanceof ObjectDefn;
            this.bindingBlock.updateTemplate(this.b.assignsTo, this.currentTBO.sendsTo.template().position(), isOtherObject, this.currentTBO.sendsTo.defn().id(), (JSExpr)r, this.bindingBlock.makeArray(wanted));
        } else if (this.currentTBO.assignsTo.type() == FieldType.CONTAINER) {
            Map<NamedType, Template> mapping = this.currentTBO.mapping();
            if (mapping == null) {
                throw new NotImplementedException("No mapping for " + this.currentTBO.assignsTo.text);
            }
            int ucidx = this.containerIdx.getAndIncrement();
            JSMethodCreator uc = this.templateCreator.createMethod("_updateContainer" + ucidx, true);
            uc.argument(J.FLEVALCONTEXT, "_cxt");
            uc.argument(J.RENDERTREE, "_renderTree");
            uc.argument(J.ELEMENT, "parent");
            uc.argument(J.ELEMENT, "currNode");
            uc.argument("e");
            uc.returnsType("void");
            JSVar expr = uc.arg(4);
            if (mapping.size() == 1) {
                this.templateMember(uc, mapping.values().iterator().next(), expr);
            } else {
                JSBlockCreator block = uc;
                for (Map.Entry<NamedType, Template> e : mapping.entrySet()) {
                    JSIfCreator ifExpr = block.ifCtor(expr, e.getKey().name());
                    this.templateMember(ifExpr.trueCase(), e.getValue(), expr);
                    block = ifExpr.falseCase();
                }
            }
            uc.returnVoid();
            this.bindingBlock.updateContainer(this.b.assignsTo, (JSExpr)r, ucidx);
        } else if (this.currentTBO.assignsTo.type() == FieldType.PUNNET) {
            int ucidx = this.containerIdx.getAndIncrement();
            JSMethodCreator uc = this.templateCreator.createMethod("_updatePunnet" + ucidx, true);
            uc.argument(J.FLEVALCONTEXT, "_cxt");
            uc.argument(J.RENDERTREE, "_renderTree");
            uc.argument(J.ELEMENT, "parent");
            uc.argument(J.ELEMENT, "currNode");
            uc.argument("e");
            uc.returnsType("void");
            uc.returnVoid();
            this.bindingBlock.updatePunnet(this.b.assignsTo, (JSExpr)r, ucidx);
        } else {
            String fromField = null;
            if (r instanceof JSLoadField) {
                fromField = ((JSLoadField)r).field();
            }
            this.bindingBlock.updateContent(this.templateName, this.b.assignsTo, this.option, this.source, fromField, (JSExpr)r);
        }
    }

    private void templateMember(JSBlockCreator block, Template e, JSExpr expr) {
        ArrayList<JSExpr> wanted = new ArrayList<JSExpr>();
        if (this.state.templateObj() != null && this.currentTBO.sendsTo != null) {
            for (int i : this.currentTBO.sendsTo.contextPosns()) {
                wanted.add((JSExpr)CollectionUtils.nth(this.state.templateObj().values(), (int)i));
            }
        }
        block.addItem(e.position(), e.webinfo().id(), expr, block.makeArray(wanted));
    }

    @Override
    public void leaveTemplateCustomization(TemplateCustomization tc) {
        TemplateBindingProcessorJS.applyStyles(this.bindingBlock, this.templateName, this.b.assignsTo, this.option, this.source, this.styles, this.cexpr, !tc.events.isEmpty());
        if (this.ie != null) {
            this.bindingBlock = this.ie.falseCase();
        }
    }

    static void applyStyles(JSBlockCreator bindingBlock, String templateName, TemplateField update, int option, JSExpr source, List<JSStyleIf> styles, List<JSExpr> cexpr, boolean hasStylingEvents) {
        if (!styles.isEmpty() || !cexpr.isEmpty()) {
            JSExpr ce = cexpr.isEmpty() ? bindingBlock.literal("null") : (cexpr.size() == 1 ? cexpr.get(0) : bindingBlock.closure(false, bindingBlock.callStatic(FunctionName.function(null, new PackageName("FLBuiltin"), "concatMany"), 1), bindingBlock.makeArray(cexpr)));
            bindingBlock.updateStyle(templateName, update, option, source, ce, styles);
            styles.clear();
            cexpr.clear();
        } else if (hasStylingEvents) {
            bindingBlock.updateStyle(templateName, update, option, source, bindingBlock.literal("null"), styles);
        }
    }

    @Override
    public void leaveTemplateBindingOption(TemplateBindingOption option) {
        this.currentTBO = null;
    }

    @Override
    public void leaveTemplateBinding(TemplateBinding tb) {
        this.sv.result(null);
    }

    static enum Mode {
        COND,
        EXPR;

    }
}

