/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SystemTestName;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.JSFunctionStateStore;
import org.flasck.flas.compiler.jsgen.SystemTestModule;
import org.flasck.flas.compiler.jsgen.UDDGeneratorJS;
import org.flasck.flas.compiler.jsgen.UnitTestStepGenerator;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.packaging.JSStorage;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.parsedForm.ut.UnitTestStep;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.jvm.J;
import org.zinutils.bytecode.JavaInfo;

public class SystemTestGenerator
extends LeafAdapter {
    private final NestedVisitor sv;
    private final JSStorage jse;
    private JSClassCreator clz;
    private JSFunctionState state;
    private JSExpr runner;
    private JSMethodCreator meth;
    private JSBlockCreator block;
    private Set<UnitDataDeclaration> globalMocks = new HashSet<UnitDataDeclaration>();
    private final List<JSExpr> explodingMocks = new ArrayList<JSExpr>();
    private final Map<UnitDataDeclaration, JSExpr> mocks = new TreeMap<UnitDataDeclaration, JSExpr>();
    private final Map<IntroduceVar, JSExpr> introductions = new TreeMap<IntroduceVar, JSExpr>(IntroduceVar.comparator);
    private final Map<NameOfThing, JSExpr> containers = new HashMap<NameOfThing, JSExpr>();
    private final List<JSExpr> steps = new ArrayList<JSExpr>();
    private final Map<Class<?>, Map<String, Object>> moduleCaches = new HashMap();
    private SystemTestName stageName;

    public SystemTestGenerator(NestedVisitor sv, JSStorage jse, SystemTest st) {
        this.sv = sv;
        this.jse = jse;
        sv.push(this);
        this.createClass(st);
    }

    public void shareWith(SystemTestModule module) {
        module.inject(this.jse, this.clz, this.meth, this.state, this.block, this.runner);
    }

    private void createClass(SystemTest st) {
        PackageName name = st.name();
        PackageName pkg = name.packageName();
        this.jse.ensurePackageExists(pkg, name.jsName());
        this.clz = this.jse.newSystemTest(st);
        this.clz.field(false, JavaInfo.Access.PRIVATE, new PackageName(J.TESTHELPER), "_runner");
        JSMethodCreator ctor = this.clz.constructor();
        this.runner = ctor.argument(J.TESTHELPER, "runner");
        ctor.argument(J.FLEVALCONTEXT, "_cxt");
        ctor.setField(false, "_runner", this.runner);
        ctor.initContext(false);
        ctor.returnVoid();
    }

    @Override
    public void visitSystemTestStage(SystemTestStage s) {
        this.stageName = s.name;
        this.meth = this.clz.createMethod(s.name.baseName(), true);
        this.meth.argument(J.FLEVALCONTEXT, "_cxt");
        this.state = new JSFunctionStateStore(this.meth, this.mocks, this.introductions, this.containers, this.moduleCaches);
        this.meth.returnsType(List.class.getName());
        this.runner = this.meth.field("_runner");
        this.block = this.meth;
        this.steps.clear();
    }

    @Override
    public void visitUnitDataDeclaration(UnitDataDeclaration udd) {
        UDDGeneratorJS.handleUDD(this.sv, this.meth, this.state, this.block, this.globalMocks, this.explodingMocks, udd);
    }

    @Override
    public void visitUnitTestStep(UnitTestStep s) {
        UnitTestStepGenerator sg = new UnitTestStepGenerator(this.sv, this.jse, this.clz, this.meth, this.state, this.block, this.runner, this.globalMocks, this.explodingMocks, true, this.stageName, this.steps.size() + 1);
        this.steps.add(this.meth.string(sg.name()));
    }

    @Override
    public void leaveSystemTestStage(SystemTestStage s) {
        this.state.meth().returnObject(this.state.meth().makeArray(this.steps));
        this.state = null;
    }

    @Override
    public void leaveSystemTest(SystemTest st) {
        this.sv.result(null);
    }
}

