/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.compiler.jsgen.GuardGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.ObjectCtorGeneratorJS;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSIfCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.flasck.flas.hsi.HSIVisitor;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.zinutils.exceptions.NotImplementedException;

public class JSHSIGenerator
extends LeafAdapter
implements HSIVisitor,
ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private JSBlockCreator block;
    private SwitchLevel currentLevel;
    private final Map<Slot, JSExpr> switchVars;
    private final List<SwitchLevel> switchStack = new ArrayList<SwitchLevel>();

    public JSHSIGenerator(JSFunctionState state, NestedVisitor sv, Map<Slot, JSExpr> switchVars, Slot slot, JSBlockCreator block) {
        this.state = state;
        this.sv = sv;
        this.block = block;
        this.currentLevel = new SwitchLevel();
        this.switchVars = switchVars;
        this.currentLevel.currentVar = switchVars.get(slot);
        this.block.head(this.currentLevel.currentVar);
        if (state != null && state.ocret() != null) {
            this.block.splitRWM(state.ocmsgs(), this.currentLevel.currentVar);
        }
        this.switchStack.add(0, this.currentLevel);
    }

    @Override
    public void hsiArgs(List<Slot> slots) {
        throw new NotImplementedException();
    }

    @Override
    public void switchOn(Slot slot) {
        this.sv.push(new JSHSIGenerator(this.state, this.sv, this.switchVars, slot, this.block));
    }

    @Override
    public void withConstructor(NameOfThing ctor) {
        if (this.currentLevel.elseBlock != null) {
            this.block = this.currentLevel.elseBlock;
        }
        JSIfCreator ifCtor = this.block.ifCtor(this.currentLevel.currentVar, ctor);
        this.block = ifCtor.trueCase();
        this.currentLevel.elseBlock = ifCtor.falseCase();
    }

    @Override
    public void constructorField(Slot parent, String field, Slot slot) {
        String var = "_" + this.switchVars.size();
        JSVar jv = new JSVar(var);
        this.block.field(jv, this.switchVars.get(parent), field);
        this.switchVars.put(slot, jv);
    }

    @Override
    public void matchNumber(int val) {
        JSBlockCreator in = this.currentLevel.matchDefault;
        if (in == null) {
            in = this.block;
        }
        JSIfCreator ifCtor = in.ifConst(this.currentLevel.currentVar, val);
        this.block = ifCtor.trueCase();
        this.currentLevel.matchDefault = ifCtor.falseCase();
    }

    @Override
    public void matchString(String val) {
        JSBlockCreator in = this.currentLevel.matchDefault;
        if (in == null) {
            in = this.block;
        }
        JSIfCreator ifCtor = in.ifConst(this.currentLevel.currentVar, val);
        this.block = ifCtor.trueCase();
        this.currentLevel.matchDefault = ifCtor.falseCase();
    }

    @Override
    public void matchDefault() {
        if (this.currentLevel.matchDefault != null) {
            this.block = this.currentLevel.matchDefault;
        }
    }

    @Override
    public void defaultCase() {
        this.block = this.currentLevel.elseBlock;
    }

    @Override
    public void errorNoCase() {
        this.block.errorNoCase();
    }

    @Override
    public void bind(Slot slot, String var) {
        if (this.block == null) {
            System.out.println("block should not be null");
            return;
        }
        this.block.bindVar(slot, this.switchVars.get(slot), var);
    }

    @Override
    public void endSwitch() {
        this.switchStack.remove(0);
        if (!this.switchStack.isEmpty()) {
            this.currentLevel = this.switchStack.get(0);
        }
        this.sv.result(null);
    }

    @Override
    public void startInline(FunctionIntro fi) {
        if (this.state != null && this.state.ocret() != null) {
            new ObjectCtorGeneratorJS(this.state, this.sv, this.block);
        } else {
            this.sv.push(new GuardGeneratorJS(this.state, this.sv, this.block));
        }
    }

    @Override
    public void result(Object r) {
        if (r != null) {
            this.block.returnObject((JSExpr)r);
        }
    }

    private static class SwitchLevel {
        private JSExpr currentVar;
        private JSBlockCreator matchDefault;
        private JSBlockCreator elseBlock;

        private SwitchLevel() {
        }
    }
}

