/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.ParenExpr;
import org.flasck.flas.commonBase.names.AssemblyName;
import org.flasck.flas.commonBase.names.CSName;
import org.flasck.flas.commonBase.names.CardName;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.ObjectName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.commonBase.names.UnitTestName;
import org.flasck.flas.compiler.jsgen.ExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.GuardGeneratorJS;
import org.flasck.flas.compiler.jsgen.HIGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.JSFunctionStateStore;
import org.flasck.flas.compiler.jsgen.JSHSIGenerator;
import org.flasck.flas.compiler.jsgen.ObjectCtorGeneratorJS;
import org.flasck.flas.compiler.jsgen.ObjectCtorStateGeneratorJS;
import org.flasck.flas.compiler.jsgen.SharesState;
import org.flasck.flas.compiler.jsgen.StructFieldGeneratorJS;
import org.flasck.flas.compiler.jsgen.SystemTestGenerator;
import org.flasck.flas.compiler.jsgen.SystemTestModule;
import org.flasck.flas.compiler.jsgen.TemplateProcessorJS;
import org.flasck.flas.compiler.jsgen.UnitTestStepGenerator;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.creators.JSCompare;
import org.flasck.flas.compiler.jsgen.creators.JSIfCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSFromCard;
import org.flasck.flas.compiler.jsgen.form.JSLiteral;
import org.flasck.flas.compiler.jsgen.form.JSString;
import org.flasck.flas.compiler.jsgen.form.JSThis;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.flasck.flas.compiler.jsgen.packaging.JSStorage;
import org.flasck.flas.compiler.templates.EventTargetZones;
import org.flasck.flas.hsi.ArgSlot;
import org.flasck.flas.hsi.HSIVisitor;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.EventHolder;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.Implements;
import org.flasck.flas.parsedForm.ImplementsContract;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.ServiceDefinition;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.assembly.ApplicationAssembly;
import org.flasck.flas.parsedForm.assembly.RoutingAction;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.ut.TestStepHolder;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.parsedForm.ut.UnitTestStep;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.repository.StackVisitor;
import org.flasck.flas.repository.StructFieldHandler;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.resolver.TemplateNestingChain;
import org.flasck.jvm.J;
import org.flasck.jvm.fl.ClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.exceptions.NotImplementedException;

public class JSGenerator
extends LeafAdapter
implements HSIVisitor,
ResultAware,
SharesState {
    private static final Logger logger = LoggerFactory.getLogger((String)"Generator");
    private final RepositoryReader repository;
    private final JSStorage jse;
    private final NestedVisitor sv;
    private final Map<EventHolder, EventTargetZones> eventMap;
    private JSMethodCreator meth;
    private JSBlockCreator block;
    private JSExpr runner;
    private final Map<Slot, JSExpr> switchVars = new HashMap<Slot, JSExpr>();
    private JSFunctionState state;
    private JSExpr evalRet;
    private ObjectAccessor currentOA;
    private StructFieldHandler structFieldHandler;
    private Map<Object, List<FunctionName>> methodMap = new HashMap<Object, List<FunctionName>>();
    private JSClassCreator currentContract;
    private Set<UnitDataDeclaration> globalMocks = new HashSet<UnitDataDeclaration>();
    private final List<JSExpr> explodingMocks = new ArrayList<JSExpr>();
    private JSClassCreator agentCreator;
    private JSClassCreator templateCreator;
    private AtomicInteger containerIdx;
    private boolean currentContractIsHandler;
    private boolean testServices;
    private UnitTestName testName;
    private final List<JSExpr> utsteps = new ArrayList<JSExpr>();
    private JSClassCreator utclz;
    private JSClassCreator appclz;
    private int recnt;

    public JSGenerator(RepositoryReader repository, JSStorage jse, StackVisitor sv, Map<EventHolder, EventTargetZones> eventMap) {
        this.repository = repository;
        this.jse = jse;
        this.sv = sv;
        this.eventMap = eventMap;
        if (sv != null) {
            sv.push(this);
        }
    }

    public JSGenerator(JSMethodCreator meth, JSExpr runner, NestedVisitor sv, JSFunctionState state, JSStorage jse) {
        this.repository = null;
        this.sv = sv;
        this.jse = jse;
        if (meth == null) {
            throw new RuntimeException("Meth cannot be null");
        }
        this.meth = meth;
        this.block = meth;
        this.runner = runner;
        if (sv != null) {
            sv.push(this);
        }
        this.state = state;
        this.eventMap = null;
    }

    @Override
    public void shareWith(SystemTestModule module) {
        module.inject(this.jse, null, this.meth, this.state, this.block, this.runner);
    }

    @Override
    public void visitObjectAccessor(ObjectAccessor oa) {
        this.currentOA = oa;
    }

    @Override
    public void leaveObjectAccessor(ObjectAccessor oa) {
        this.currentOA = null;
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        this.switchVars.clear();
        if (fn.intros().isEmpty() || !fn.generate) {
            this.meth = null;
            return;
        }
        PackageName pkg = fn.name().packageName();
        NameOfThing cxName = fn.name().containingCard() != null ? fn.name().wrappingObject() : fn.name().inContext;
        this.jse.ensurePackageExists(pkg, cxName.uniqueName());
        this.meth = this.jse.newFunction(fn.name(), pkg, cxName, fn.hasState(), fn.name().name);
        this.meth.argument("_cxt");
        this.meth.argumentList();
        for (int i = 0; i < fn.argCountWithoutHolder(); ++i) {
            this.meth.argument("_" + i);
        }
        this.block = this.meth;
        this.state = new JSFunctionStateStore(this.meth);
        if (fn.hasState()) {
            this.loadContainers(this.state, fn.name());
        }
        if (fn.constNess().isConstant()) {
            this.state.cacheResult();
            this.meth.checkCached();
        }
    }

    @Override
    public void visitTuple(TupleAssignment e) {
        this.switchVars.clear();
        PackageName pkg = e.name().packageName();
        NameOfThing cxName = e.name().inContext;
        this.jse.ensurePackageExists(pkg, cxName.jsName());
        this.meth = this.jse.newFunction(e.name(), pkg, cxName, false, e.name().name);
        this.meth.argument("_cxt");
        this.meth.argumentList();
        this.block = this.meth;
        this.state = new JSFunctionStateStore(this.meth);
        this.sv.push(new ExprGeneratorJS(this.state, this.sv, this.block, false));
    }

    @Override
    public void visitTupleMember(TupleMember e) {
        this.switchVars.clear();
        PackageName pkg = e.name().packageName();
        NameOfThing cxName = e.name().inContext;
        this.jse.ensurePackageExists(pkg, cxName.jsName());
        this.meth = this.jse.newFunction(e.name(), pkg, cxName, false, e.name().name);
        this.meth.argument("_cxt");
        this.meth.argumentList();
        this.block = this.meth;
        this.state = new JSFunctionStateStore(this.meth);
        this.meth.returnObject(this.meth.defineTupleMember(e));
    }

    @Override
    public void visitStructDefn(StructDefn obj) {
        if (!obj.generate) {
            return;
        }
        PackageName pkg = obj.name().packageName();
        this.jse.ensurePackageExists(pkg, obj.name().container().uniqueName());
        this.jse.struct(obj);
        JSClassCreator ctr = this.jse.newClass(pkg, obj.name());
        ctr.inheritsFrom(null, J.JVM_FIELDS_CONTAINER_WRAPPER);
        ctr.implementsJava(J.AREYOUA);
        ctr.implementsJava(J.ISDATA);
        ctr.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.FIELDS_CONTAINER), "state");
        ctr.wantsTypeName();
        JSMethodCreator ctor = ctr.constructor();
        JSVar cx = ctor.argument(J.FLEVALCONTEXT, "_cxt");
        ctor.superArg(cx);
        ctor.superArg(ctor.string(obj.name.uniqueName()));
        ctor.stateField(true);
        ctor.storeField(true, this.evalRet, "_type", ctor.string(obj.name.uniqueName()));
        ctor.returnVoid();
        JSMethodCreator areYouA = ctr.createMethod("_areYouA", true);
        areYouA.argument(J.EVALCONTEXT, "_cxt");
        areYouA.argument(J.STRING, "ty");
        areYouA.returnsType("boolean");
        JSVar aya = areYouA.arg(1);
        JSIfCreator ifblk = areYouA.ifTrue(new JSCompare(aya, areYouA.string(obj.name().uniqueName())));
        ifblk.trueCase().returnObject(ifblk.trueCase().literal("true"));
        JSBlockCreator fc = ifblk.falseCase();
        for (UnionTypeDefn u : this.repository.unionsContaining(obj)) {
            JSIfCreator ifu = fc.ifTrue(new JSCompare(aya, areYouA.string(u.name().uniqueName())));
            ifu.trueCase().returnObject(ifblk.trueCase().literal("true"));
            fc = ifu.falseCase();
        }
        fc.returnObject(fc.literal("false"));
        this.meth = ctr.createMethod("eval", false);
        this.meth.argument(J.FLEVALCONTEXT, "_cxt");
        this.meth.argumentList();
        this.evalRet = this.meth.newOf(obj.name());
        this.block = this.meth;
        this.structFieldHandler = sf -> {
            if (sf.name.equals("id")) {
                return;
            }
            if (sf.init == null) {
                JSVar arg = this.meth.argument(sf.name);
                this.meth.storeField(false, this.evalRet, sf.name, arg);
            } else {
                new StructFieldGeneratorJS(this.state, this.sv, this.block, sf.name, this.evalRet);
            }
        };
    }

    @Override
    public void visitObjectDefn(ObjectDefn obj) {
        if (!obj.generate) {
            return;
        }
        PackageName pkg = obj.name().packageName();
        this.jse.ensurePackageExists(pkg, obj.name().container().uniqueName());
        this.jse.object(obj);
        this.templateCreator = this.jse.newClass(pkg, obj.name());
        this.templateCreator.inheritsFrom(new PackageName("FLObject"), J.FLOBJECT);
        this.templateCreator.implementsJava(J.AREYOUA);
        this.templateCreator.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.FIELDS_CONTAINER), "state");
        this.templateCreator.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.FLCARD), "_card");
        for (ObjectContract c : obj.contracts) {
            this.templateCreator.field(false, JavaInfo.Access.PROTECTED, c.implementsType().namedDefn().name(), c.varName().baseName());
        }
        JSMethodCreator areYouA = this.templateCreator.createMethod("_areYouA", true);
        areYouA.argument(J.EVALCONTEXT, "_cxt");
        areYouA.argument(J.STRING, "ty");
        areYouA.returnsType("boolean");
        areYouA.returnCompare(areYouA.arg(1), areYouA.string(obj.name().uniqueName()));
        JSMethodCreator ud = this.templateCreator.createMethod("_updateDisplay", true);
        ud.argument("_cxt");
        ud.returnsType("void");
        JSIfCreator ifcard = ud.ifTrue(ud.literal("this._card"));
        ifcard.trueCase().assertable(ud.literal("this._card"), "_updateDisplay", ud.literal("this._card._renderTree"));
        ud.returnVoid();
        JSMethodCreator ctor = this.templateCreator.constructor();
        JSVar cx = ctor.argument(J.FLEVALCONTEXT, "_cxt");
        JSVar ic = ctor.argument("_incard");
        ctor.superArg(cx);
        ctor.superArg(ic);
        ctor.setField(true, "_card", (JSExpr)ctor.arg(1));
        ctor.stateField(true);
        ctor.returnVoid();
        ArrayList<FunctionName> methods = new ArrayList<FunctionName>();
        this.methodMap.put(obj, methods);
        this.jse.eventMap(obj.name(), this.eventMap.get(obj));
        this.jse.methodList(obj.name(), methods);
        this.containerIdx = new AtomicInteger(1);
    }

    @Override
    public void visitStructField(StructField sf) {
        if (this.structFieldHandler != null && sf.generate) {
            this.structFieldHandler.visitStructField(sf);
        }
    }

    @Override
    public void visitStructFieldAccessor(StructField sf) {
        if (!sf.generate) {
            return;
        }
        PackageName pkg = sf.name().packageName();
        NameOfThing cxName = sf.name().container();
        JSMethodCreator meth = this.jse.newFunction(null, pkg, cxName, true, "_field_" + sf.name);
        meth.argument("_cxt");
        meth.argumentList();
        meth.returnObject(meth.loadField(new JSThis(), sf.name));
    }

    @Override
    public void leaveStructDefn(StructDefn obj) {
        if (this.evalRet != null) {
            this.meth.returnObject(this.evalRet);
        }
        this.block = null;
        this.evalRet = null;
        this.meth = null;
        this.structFieldHandler = null;
    }

    @Override
    public void visitObjectMethod(ObjectMethod om) {
        int i;
        if (!om.generate) {
            return;
        }
        logger.info("visiting object method " + om.name());
        this.switchVars.clear();
        if (!om.isConverted()) {
            this.meth = null;
            return;
        }
        PackageName pkg = om.name().packageName();
        this.jse.ensurePackageExists(pkg, om.name().inContext.uniqueName());
        this.meth = this.jse.newFunction(om.name(), pkg, om.name().container(), this.currentOA != null || om.contractMethod() != null || om.hasObject() || om.isEvent() || om.hasState(), om.name().name);
        if (om.hasImplements()) {
            if (om.getImplements().getParent() instanceof ServiceDefinition) {
                this.meth.noJS();
            }
            Implements impl = om.getImplements();
            this.methodMap.get(impl).add(om.name());
        } else if (om.hasObject()) {
            this.methodMap.get(om.getObject()).add(om.name());
        }
        this.meth.argument("_cxt");
        this.meth.argumentList();
        for (i = 0; i < om.argCountWithoutHolder(); ++i) {
            this.meth.argument("_" + i);
        }
        if (om.contractMethod() != null) {
            this.meth.argument("_" + i);
        }
        this.block = this.meth;
        this.state = new JSFunctionStateStore(this.meth);
        this.loadContainers(this.state, om.name());
    }

    @Override
    public void visitObjectCtor(ObjectCtor oc) {
        if (!oc.generate) {
            return;
        }
        this.switchVars.clear();
        PackageName pkg = oc.name().packageName();
        this.jse.ensurePackageExists(pkg, oc.name().inContext.uniqueName());
        this.meth = this.jse.newFunction(null, pkg, oc.name().container(), false, oc.name().name);
        this.meth.argumentList();
        this.meth.argument(J.FLEVALCONTEXT, "_cxt");
        this.meth.argument(J.FLCARD, "_card");
        for (int i = 0; i < oc.argCount(); ++i) {
            this.meth.argument("_" + i);
        }
        this.block = this.meth;
        ObjectDefn od = oc.getObject();
        JSExpr ocret = this.meth.newOf(od.name(), Arrays.asList(this.meth.arg(1)));
        JSExpr ocmsgs = this.meth.makeArray(new ArrayList<JSExpr>());
        this.state = new JSFunctionStateStore(this.meth);
        this.loadContainers(this.state, oc.name());
        this.state.objectCtor(ocret, ocmsgs);
        for (ObjectContract ctr : od.contracts) {
            String cname = "_ctr_" + ctr.varName().var;
            this.meth.argument(cname);
            this.meth.copyContract(ocret, ctr.varName().var, cname);
        }
    }

    @Override
    public void visitStateDefinition(StateDefinition state) {
        if (this.state != null && this.state.ocret() != null) {
            new ObjectCtorStateGeneratorJS(this.state, this.sv, this.block);
        }
    }

    @Override
    public void hsiArgs(List<Slot> slots) {
        for (Slot s : slots) {
            if (((ArgSlot)s).isContainer()) continue;
            this.switchVars.put(s, new JSVar("_" + this.switchVars.size()));
        }
    }

    @Override
    public void switchOn(Slot slot) {
        this.sv.push(new JSHSIGenerator(this.state, this.sv, this.switchVars, slot, this.block));
    }

    @Override
    public void startInline(FunctionIntro fi) {
        if (this.state.ocret() != null) {
            new ObjectCtorGeneratorJS(this.state, this.sv, this.meth);
        } else {
            this.sv.push(new GuardGeneratorJS(this.state, this.sv, this.block));
        }
    }

    @Override
    public void withConstructor(NameOfThing string) {
        throw new NotImplementedException();
    }

    @Override
    public void constructorField(Slot parent, String field, Slot slot) {
        throw new NotImplementedException();
    }

    @Override
    public void matchNumber(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void matchString(String s) {
        throw new NotImplementedException();
    }

    @Override
    public void matchDefault() {
        throw new NotImplementedException();
    }

    @Override
    public void defaultCase() {
        throw new NotImplementedException();
    }

    @Override
    public void errorNoCase() {
        throw new NotImplementedException();
    }

    @Override
    public void bind(Slot slot, String var) {
        this.block.bindVar(slot, this.switchVars.get(slot), var);
    }

    @Override
    public void endSwitch() {
        throw new NotImplementedException();
    }

    @Override
    public void leaveFunction(FunctionDefinition fn) {
        if (this.meth == null) {
            return;
        }
        this.meth = null;
        this.state = null;
    }

    @Override
    public void leaveTuple(TupleAssignment ta) {
        if (this.meth == null) {
            return;
        }
        this.meth = null;
        this.state = null;
    }

    @Override
    public void leaveTupleMember(TupleMember tm) {
        if (this.meth == null) {
            return;
        }
        this.meth = null;
        this.state = null;
    }

    @Override
    public void leaveObjectMethod(ObjectMethod om) {
        if (this.meth == null) {
            return;
        }
        this.meth = null;
        this.state = null;
        this.templateCreator = null;
    }

    @Override
    public void leaveObjectCtor(ObjectCtor oc) {
        if (this.meth == null) {
            return;
        }
        this.meth = null;
        this.state = null;
    }

    @Override
    public void visitContractDecl(ContractDecl cd) {
        PackageName pkg = cd.name().packageName();
        this.jse.ensurePackageExists(pkg, cd.name().container().uniqueName());
        this.currentContract = this.jse.newClass(pkg, cd.name());
        this.currentContract.justAnInterface();
        JSMethodCreator ctor = this.currentContract.constructor();
        ctor.argument(J.FLEVALCONTEXT, "_cxt");
        this.jse.contract(cd);
        if (cd.type == ContractDecl.ContractType.HANDLER) {
            this.currentContractIsHandler = true;
            this.currentContract.inheritsFrom(new PackageName("IdempotentHandler"), J.OBJECT);
            this.currentContract.implementsJava(J.IDEMPOTENTHANDLER);
        }
        JSMethodCreator ctrName = this.currentContract.createMethod("name", true);
        ctrName.returnObject(new JSString(cd.name().uniqueName()));
        JSMethodCreator methods = this.currentContract.createMethod("_methods", true);
        methods.noJVM();
        ArrayList<JSExpr> names = new ArrayList<JSExpr>();
        for (ContractMethodDecl m : cd.methods) {
            names.add(methods.string(m.name.name));
        }
        methods.returnObject(methods.jsArray(names));
    }

    @Override
    public void visitContractMethod(ContractMethodDecl cmd) {
        this.currentContract.field(true, JavaInfo.Access.PUBLICSTATIC, new PackageName("int"), "_nf_" + cmd.name.name, cmd.args.size());
        JSMethodCreator meth = this.currentContract.createMethod(cmd.name.name, true);
        if (!cmd.required) {
            meth.makeOptional();
        }
        meth.argument(J.FLEVALCONTEXT, "_cxt");
        meth.argumentList();
        for (int k = 0; k < cmd.args.size(); ++k) {
            meth.argument("_" + k);
        }
        meth.handlerArg();
        meth.returnObject(new JSLiteral("null"));
        if (this.currentContractIsHandler && (cmd.name.name.equals("success") || cmd.name.name.contentEquals("failure"))) {
            meth.noJVM();
        }
    }

    @Override
    public void leaveContractDecl(ContractDecl cd) {
        this.currentContract.constructor().returnVoid();
        this.currentContract = null;
        this.currentContractIsHandler = false;
    }

    @Override
    public void visitAgentDefn(AgentDefinition ad) {
        PackageName pkg = (PackageName)ad.name().container();
        this.jse.ensurePackageExists(pkg, pkg.uniqueName());
        this.agentCreator = this.jse.newClass(pkg, ad.name());
        this.agentCreator.inheritsFrom(null, J.FLAGENT);
        this.agentCreator.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.FIELDS_CONTAINER), "state");
        this.agentCreator.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.CONTRACTSTORE), "store");
        JSMethodCreator ctor = this.agentCreator.constructor();
        JSVar ctrCxt = ctor.argument(J.FLEVALCONTEXT, "_cxt");
        ctor.superArg(ctrCxt);
        ctor.stateField(true);
        ctor.fieldObject("_contracts", new PackageName("ContractStore"));
        JSMethodCreator updateDisplay = this.agentCreator.createMethod("_updateDisplay", true);
        updateDisplay.argument(J.FLEVALCONTEXT, "_cxt");
        updateDisplay.argument(J.RENDERTREE, "_renderTree");
        updateDisplay.returnsType("void");
        updateDisplay.returnVoid();
        JSMethodCreator resizeDisplay = this.agentCreator.createMethod("_resizeDisplayElements", true);
        resizeDisplay.argument(J.FLEVALCONTEXT, "_cxt");
        resizeDisplay.argument(J.RENDERTREE, "_renderTree");
        resizeDisplay.returnsType("void");
        resizeDisplay.returnVoid();
        JSMethodCreator meth = this.agentCreator.createMethod("name", true);
        meth.argument("_cxt");
        meth.returnObject(new JSString(ad.name().uniqueName()));
        JSMethodCreator ctrProvider = this.agentCreator.createMethod("_contract", false);
        ctrProvider.noJVM();
        ctrProvider.argument("_cxt");
        ctrProvider.argument("_ctr");
        this.structFieldHandler = sf -> {
            if (sf.init != null) {
                new StructFieldGeneratorJS(this.state, this.sv, ctor, sf.name, new JSThis());
            }
        };
    }

    @Override
    public void visitCardDefn(CardDefinition cd) {
        PackageName pkg = (PackageName)cd.name().container();
        this.jse.ensurePackageExists(pkg, pkg.uniqueName());
        this.templateCreator = this.agentCreator = this.jse.newClass(pkg, cd.name());
        this.agentCreator.inheritsFrom(new PackageName("FLCard"), J.FLCARD);
        this.agentCreator.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.FIELDS_CONTAINER), "state");
        this.agentCreator.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.CONTRACTSTORE), "store");
        JSMethodCreator ctor = this.agentCreator.constructor();
        JSVar ctrCxt = ctor.argument(J.FLEVALCONTEXT, "_cxt");
        ctor.superArg(ctrCxt);
        ctor.fieldObject("_contracts", new PackageName("ContractStore"));
        if (!cd.templates.isEmpty()) {
            ctor.superArg(ctor.string(cd.templates.get(0).webinfo().id()));
            ctor.setField(new JSThis(), "_template", (JSExpr)ctor.string(cd.templates.get(0).webinfo().id()));
        } else {
            ctor.superArg(ctor.string(null));
            JSMethodCreator updateDisplay = this.agentCreator.createMethod("_updateDisplay", true);
            updateDisplay.argument(J.FLEVALCONTEXT, "_cxt");
            updateDisplay.argument(J.RENDERTREE, "_renderTree");
            updateDisplay.returnsType("void");
            updateDisplay.returnVoid();
        }
        ctor.stateField(true);
        JSMethodCreator meth = this.agentCreator.createMethod("name", true);
        meth.argument("_cxt");
        meth.returnObject(new JSString(cd.name().uniqueName()));
        JSMethodCreator ctrProvider = this.agentCreator.createMethod("_contract", false);
        ctrProvider.noJVM();
        ctrProvider.argument("_cxt");
        ctrProvider.argument("_ctr");
        ArrayList<FunctionName> methods = new ArrayList<FunctionName>();
        this.methodMap.put(cd, methods);
        this.jse.methodList(cd.name(), methods);
        this.jse.eventMap(cd.name(), this.eventMap.get(cd));
        this.structFieldHandler = sf -> {
            if (sf.init != null) {
                new StructFieldGeneratorJS(this.state, this.sv, ctor, sf.name, new JSThis());
            }
        };
        this.containerIdx = new AtomicInteger(1);
    }

    @Override
    public void visitServiceDefn(ServiceDefinition sd) {
        PackageName pkg = (PackageName)sd.name().container();
        this.jse.ensurePackageExists(pkg, pkg.uniqueName());
        this.agentCreator = this.jse.newClass(pkg, sd.name());
        this.agentCreator.notJS();
        this.templateCreator = this.agentCreator;
        this.agentCreator.inheritsFrom(null, J.CONTRACT_HOLDER);
        this.agentCreator.inheritsField(true, JavaInfo.Access.PROTECTED, new PackageName(J.CONTRACTSTORE), "store");
        JSMethodCreator ctor = this.agentCreator.constructor();
        JSVar ctrCxt = ctor.argument(J.FLEVALCONTEXT, "_cxt");
        ctor.superArg(ctrCxt);
        JSMethodCreator meth = this.agentCreator.createMethod("name", true);
        meth.argument("_cxt");
        meth.returnObject(new JSString(sd.name().uniqueName()));
        this.containerIdx = new AtomicInteger(1);
        ArrayList methods = new ArrayList();
        this.methodMap.put(sd, methods);
    }

    @Override
    public void visitImplements(ImplementsContract ic) {
        CSName csn = (CSName)ic.name();
        JSMethodCreator ctor = this.agentCreator.constructor();
        ctor.recordContract(ic.actualType().name(), csn);
        JSClassCreator svc = this.jse.newClass(csn.packageName(), csn);
        JSMethodCreator svcCtor = svc.constructor();
        svcCtor.argument(J.FLEVALCONTEXT, "_cxt");
        svc.field(true, JavaInfo.Access.PRIVATE, new PackageName(J.OBJECT), "_card");
        svcCtor.argument(J.OBJECT, "_incard");
        svcCtor.setField(false, "_card", (JSExpr)new JSVar("_incard"));
        svcCtor.returnVoid();
        ArrayList<FunctionName> methods = new ArrayList<FunctionName>();
        this.methodMap.put(ic, methods);
        this.jse.methodList(ic.name(), methods);
    }

    @Override
    public void visitProvides(Provides p) {
        CSName csn = (CSName)p.name();
        JSMethodCreator ctor = this.agentCreator.constructor();
        ctor.recordContract(p.actualType().name(), csn);
        JSClassCreator svc = this.jse.newClass(csn.packageName(), csn);
        svc.implementsJava(p.actualType().name().javaName());
        if (!this.agentCreator.wantJS()) {
            svc.notJS();
        }
        JSMethodCreator svcCtor = svc.constructor();
        svcCtor.argument(J.FLEVALCONTEXT, "_cxt");
        svc.field(true, JavaInfo.Access.PRIVATE, new PackageName(J.OBJECT), "_card");
        svcCtor.argument(J.OBJECT, "_incard");
        svcCtor.setField(false, "_card", (JSExpr)new JSVar("_incard"));
        svcCtor.returnVoid();
        ArrayList<FunctionName> methods = new ArrayList<FunctionName>();
        this.methodMap.put(p, methods);
        if (this.agentCreator.wantJS()) {
            this.jse.methodList(p.name(), methods);
        }
    }

    @Override
    public void visitHandlerImplements(HandlerImplements hi) {
        PackageName pkg = hi.name().packageName();
        this.jse.ensurePackageExists(pkg, hi.name().container().uniqueName());
        new HIGeneratorJS(this.sv, this.jse, this.methodMap, hi);
    }

    @Override
    public void leaveProvides(Provides p) {
        JSMethodCreator ctor = this.agentCreator.constructor();
        ctor.requireContract(p.referAsVar, p.actualType().name());
        this.block = null;
        this.evalRet = null;
        this.meth = null;
    }

    @Override
    public void visitRequires(RequiresContract rc) {
        JSMethodCreator ctor = this.agentCreator.constructor();
        ctor.requireContract(rc.referAsVar, rc.actualType().name());
    }

    @Override
    public void leaveAgentDefn(AgentDefinition s) {
        this.agentCreator.constructor().returnVoid();
        this.agentCreator = null;
    }

    @Override
    public void visitTemplate(Template t, boolean isFirst) {
        JSExpr source;
        Object name = "_updateDisplay";
        if (!isFirst) {
            name = "_updateTemplate" + t.position();
        }
        JSMethodCreator updateDisplay = this.templateCreator.createMethod((String)name, true);
        updateDisplay.argument(J.FLEVALCONTEXT, "_cxt");
        updateDisplay.argument(J.RENDERTREE, "_renderTree");
        Iterator links = null;
        TemplateNestingChain.Link n1 = null;
        NestingChain chain = t.nestingChain();
        if (chain != null) {
            links = chain.iterator();
            n1 = (TemplateNestingChain.Link)links.next();
            updateDisplay.argument(n1.name().var);
            updateDisplay.argument(List.class.getName(), "_tc");
        }
        updateDisplay.returnsType("void");
        this.state = new JSFunctionStateStore(updateDisplay);
        this.loadContainers(this.state, FunctionName.function(t.kw, this.templateCreator.name(), (String)name));
        if (n1 != null) {
            LinkedHashMap<String, JSExpr> tom = new LinkedHashMap<String, JSExpr>();
            source = updateDisplay.boundVar(n1.name().var);
            this.popVar(tom, n1, source);
            JSExpr tc = updateDisplay.boundVar("_tc");
            int pos = 0;
            while (links.hasNext()) {
                this.popVar(tom, (TemplateNestingChain.Link)links.next(), updateDisplay.arrayElt(tc, pos++));
            }
            this.state.provideTemplateObject(tom);
        } else {
            source = updateDisplay.literal("null");
        }
        new TemplateProcessorJS(this.state, this.sv, this.templateCreator, this.containerIdx, updateDisplay, source, t);
    }

    private void popVar(Map<String, JSExpr> tom, TemplateNestingChain.Link l, JSExpr expr) {
        tom.put(l.name().var, expr);
    }

    @Override
    public void leaveCardDefn(CardDefinition s) {
        this.agentCreator.constructor().returnVoid();
        this.agentCreator = null;
        this.templateCreator = null;
        this.containerIdx = null;
    }

    @Override
    public void leaveServiceDefn(ServiceDefinition s) {
        this.agentCreator.constructor().returnVoid();
        this.agentCreator = null;
        this.templateCreator = null;
        this.containerIdx = null;
    }

    @Override
    public void leaveObjectDefn(ObjectDefn s) {
        this.templateCreator = null;
        this.containerIdx = null;
    }

    @Override
    public void visitUnitTest(UnitTestCase e) {
        UnitTestName clzName = e.name;
        if (this.currentOA != null) {
            throw new NotImplementedException("I don't think you can nest a unit test in an accessor");
        }
        NameOfThing pkg = clzName.container();
        this.jse.ensurePackageExists(pkg, e.name.container().jsName());
        this.utclz = this.jse.newUnitTest(e);
        this.utclz.field(false, JavaInfo.Access.PRIVATE, new PackageName(J.TESTHELPER), "_runner");
        JSMethodCreator ctor = this.utclz.constructor();
        JSVar r = ctor.argument(J.TESTHELPER, "runner");
        ctor.argument(J.FLEVALCONTEXT, "_cxt");
        ctor.setField(false, "_runner", (JSExpr)r);
        ctor.initContext(false);
        ctor.returnVoid();
        this.meth = this.utclz.createMethod("dotest", true);
        this.meth.argument(J.FLEVALCONTEXT, "_cxt");
        this.meth.returnsType(List.class.getName());
        this.runner = this.meth.field("_runner");
        this.meth.helper(this.runner);
        this.testServices = true;
        this.testName = clzName;
        if (this.involvesServices(e)) {
            e.dontRunJS();
            ctor.noJS();
            this.meth.noJS();
            this.testServices = false;
        }
        this.block = this.meth;
        this.state = new JSFunctionStateStore(this.meth);
        this.state.container(new PackageName("_DisplayUpdater"), this.runner);
        this.explodingMocks.clear();
        for (UnitDataDeclaration udd : this.globalMocks) {
            if (!(udd.ofType.namedDefn() instanceof ContractDecl)) continue;
            this.declareGlobalMock(udd);
        }
        for (UnitDataDeclaration udd : this.globalMocks) {
            if (udd.ofType.namedDefn() instanceof ContractDecl) continue;
            this.declareGlobalMock(udd);
        }
        this.utsteps.clear();
    }

    private void declareGlobalMock(UnitDataDeclaration udd) {
        UnitTestStepGenerator sg = new UnitTestStepGenerator(null, this.jse, this.utclz, this.meth, this.state, null, this.runner, this.globalMocks, this.explodingMocks, this.testServices, null, 0);
        sg.visitUnitDataDeclaration(udd);
        sg.leaveUnitTestStep(null);
    }

    private boolean involvesServices(TestStepHolder e) {
        for (UnitTestStep s : e.steps) {
            if (!(s instanceof UnitDataDeclaration)) continue;
            UnitDataDeclaration udd = (UnitDataDeclaration)s;
            if (!(udd.ofType.namedDefn() instanceof ServiceDefinition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitUnitDataDeclaration(UnitDataDeclaration udd) {
        this.globalMocks.add(udd);
    }

    @Override
    public void visitUnitTestStep(UnitTestStep s) {
        UnitTestStepGenerator sg = new UnitTestStepGenerator(this.sv, this.jse, this.utclz, this.meth, this.state, this.block, this.runner, this.globalMocks, this.explodingMocks, this.testServices, this.testName, this.utsteps.size() + 1);
        this.utsteps.add(this.meth.string(sg.name()));
    }

    @Override
    public void leaveUnitTest(TestStepHolder e) {
        if (!this.explodingMocks.isEmpty()) {
            UnitTestStepGenerator sg = new UnitTestStepGenerator(null, this.jse, this.utclz, this.meth, this.state, this.block, this.runner, this.globalMocks, this.explodingMocks, this.testServices, this.testName, this.utsteps.size() + 1);
            for (JSExpr m : this.explodingMocks) {
                sg.assertSatisfied(m);
            }
            sg.method().returnVoid();
            this.utsteps.add(this.meth.string(sg.name()));
        }
        this.state.meth().returnObject(this.state.meth().makeArray(this.utsteps));
        this.meth = null;
        this.state = null;
    }

    @Override
    public void visitSystemTest(SystemTest st) {
        new SystemTestGenerator(this.sv, this.jse, st);
    }

    @Override
    public void visitAssembly(ApplicationAssembly e) {
        AssemblyName an = e.name();
        this.appclz = this.jse.newClass(an.packageName(), new SolidName(e.name(), "_Application"));
        this.appclz.inheritsFrom(new PackageName("Application"), J.FLAPPLICATION);
        this.recnt = 0;
        JSMethodCreator ctor = this.appclz.constructor();
        JSVar cc = ctor.argument(ClientContext.class.getName(), "_cxt");
        JSVar div = ctor.argument(J.ELEMENT, "div");
        ctor.superArg(cc);
        ctor.superArg(div);
        this.appclz.inheritsField(false, JavaInfo.Access.PROTECTED, new PackageName(J.STRING), "title");
        ctor.setField(new JSThis(), "title", (JSExpr)new JSString(e.getTitle()));
        ctor.returnVoid();
        JSMethodCreator bu = this.appclz.createMethod("baseUri", true);
        bu.returnsType(J.STRING);
        bu.returnObject(new JSString(e.getBaseUri()));
        if (e.routing() != null) {
            this.jse.applRouting(this.appclz, e.name(), e.routing());
        }
    }

    @Override
    public void visitRoutingExpr(RoutingAction a, int pos, Expr e) {
        while (e instanceof ParenExpr) {
            e = (Expr)((ParenExpr)e).expr;
        }
        if (e instanceof ApplyExpr) {
            this.meth = this.appclz.createMethod("routing_expr_" + this.recnt, true);
            a.exprFn(pos, this.recnt);
            ++this.recnt;
            this.meth.argument(J.FLEVALCONTEXT, "_cxt");
            this.block = this.meth;
            this.state = new JSFunctionStateStore(this.meth);
            this.sv.push(new ExprGeneratorJS(this.state, this.sv, this.block, false));
        }
    }

    @Override
    public void leaveRoutingExpr(RoutingAction a, int pos, Expr e) {
        this.meth = null;
    }

    @Override
    public void leaveAssembly(ApplicationAssembly e) {
        this.appclz = null;
        this.recnt = 0;
    }

    @Override
    public void traversalDone() {
        this.jse.complete();
    }

    @Override
    public void result(Object r) {
        if (r != null) {
            this.block.returnObject((JSExpr)r);
        }
    }

    private void loadContainers(JSFunctionState fs, FunctionName name) {
        NameOfThing top = name.wrappingObject();
        JSExpr first = null;
        if (top == null) {
            return;
        }
        if (name.name.startsWith("_ctor_")) {
            first = new JSVar("_v1");
            fs.container(top, first);
        } else {
            fs.container(top, new JSThis());
        }
        do {
            if (top instanceof CardName || top instanceof ObjectName) {
                if (this.runner != null) {
                    fs.container(new PackageName("_DisplayUpdater"), this.runner);
                } else {
                    if (first == null) {
                        first = new JSThis();
                    }
                    fs.container(new PackageName("_DisplayUpdater"), first);
                }
            }
            if (!((top = top.container()) instanceof CardName) && !(top instanceof ObjectName)) continue;
            JSFromCard fc = new JSFromCard(top);
            if (first == null) {
                first = fc;
            }
            fs.container(top, fc);
        } while (top != null && !(top instanceof PackageName));
    }

    public static JSGenerator forTests(JSMethodCreator meth, JSExpr runner, NestedVisitor nv) {
        return new JSGenerator(meth, runner, nv, null, null);
    }

    public static JSGenerator forTests(JSMethodCreator meth, JSExpr runner, NestedVisitor nv, JSStorage jse) {
        return new JSGenerator(meth, runner, nv, null, jse);
    }

    public static JSGenerator forTests(JSMethodCreator meth, JSExpr runner, NestedVisitor nv, JSFunctionState state) {
        return new JSGenerator(meth, runner, nv, state, null);
    }

    public static JSGenerator forTests(JSMethodCreator meth, JSExpr runner, NestedVisitor nv, JSStorage jse, JSFunctionState state) {
        return new JSGenerator(meth, runner, nv, state, jse);
    }

    public static class XCArg {
        public final int arg;
        public final JSExpr expr;

        public XCArg(int arg, JSExpr expr) {
            this.arg = arg;
            this.expr = expr;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XCArg)) {
                return false;
            }
            XCArg o = (XCArg)obj;
            return o.arg == this.arg && o.expr == this.expr;
        }

        public int hashCode() {
            return this.arg ^ this.expr.hashCode();
        }

        public String toString() {
            return this.arg + ":" + this.expr;
        }
    }
}

