/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;

public class JSFunctionStateStore
implements JSFunctionState {
    public final Map<UnitDataDeclaration, JSExpr> mocks;
    public final Map<IntroduceVar, JSExpr> introductions;
    private final Map<NameOfThing, JSExpr> containers;
    private Map<String, JSExpr> templateObj;
    private final JSMethodCreator meth;
    private JSExpr ocret;
    private JSExpr ocmsgs;
    private boolean cacheResult;
    private final Map<Class<?>, Map<String, Object>> moduleCaches;

    public JSFunctionStateStore(JSMethodCreator meth) {
        this(meth, new TreeMap<UnitDataDeclaration, JSExpr>(), new TreeMap<IntroduceVar, JSExpr>(IntroduceVar.comparator), new HashMap<NameOfThing, JSExpr>(), new HashMap());
    }

    public JSFunctionStateStore(JSMethodCreator meth, Map<UnitDataDeclaration, JSExpr> mocks, Map<IntroduceVar, JSExpr> introductions, Map<NameOfThing, JSExpr> containers, Map<Class<?>, Map<String, Object>> moduleCaches) {
        this.meth = meth;
        this.mocks = mocks;
        this.introductions = introductions;
        this.containers = containers;
        this.moduleCaches = moduleCaches;
    }

    @Override
    public JSMethodCreator meth() {
        return this.meth;
    }

    @Override
    public Map<UnitDataDeclaration, JSExpr> mocks() {
        return this.mocks;
    }

    @Override
    public Map<IntroduceVar, JSExpr> introductions() {
        return this.introductions;
    }

    @Override
    public Map<NameOfThing, JSExpr> containers() {
        return this.containers;
    }

    @Override
    public boolean hasContainer(NameOfThing name) {
        return this.containers.containsKey(name);
    }

    @Override
    public void container(NameOfThing name, JSExpr expr) {
        if (this.containers.containsKey(name)) {
            throw new CantHappenException("should not offer multiple definitions for " + name);
        }
        this.containers.put(name, expr);
    }

    @Override
    public JSExpr container(NameOfThing name) {
        if (!this.containers.containsKey(name)) {
            throw new CantHappenException("There is no container for " + (name == null ? "NULL" : name.uniqueName()) + " in " + this.meth.jsName() + "; have " + this.containers);
        }
        return this.containers.get(name);
    }

    @Override
    public void provideTemplateObject(Map<String, JSExpr> tc) {
        this.templateObj = tc;
    }

    @Override
    public Map<String, JSExpr> templateObj() {
        return this.templateObj;
    }

    @Override
    public void objectCtor(JSExpr ocret, JSExpr ocmsgs) {
        this.ocret = ocret;
        this.ocmsgs = ocmsgs;
    }

    @Override
    public JSExpr ocret() {
        return this.ocret;
    }

    @Override
    public JSExpr ocmsgs() {
        return this.ocmsgs;
    }

    @Override
    public void addMock(UnitDataDeclaration udd, JSExpr resolvesTo) {
        if (this.mocks.containsKey(udd)) {
            throw new NotImplementedException("Duplicate mock " + udd.name.uniqueName());
        }
        this.mocks.put(udd, resolvesTo);
    }

    @Override
    public void addIntroduction(IntroduceVar var, JSExpr jsv) {
        if (this.introductions.containsKey(var)) {
            throw new NotImplementedException("Duplicate introduction " + var.name().uniqueName());
        }
        this.introductions.put(var, jsv);
    }

    @Override
    public JSExpr resolveMock(JSBlockCreator block, UnitDataDeclaration udd) {
        if (this.mocks.containsKey(udd)) {
            return this.mocks.get(udd);
        }
        throw new RuntimeException("No mock for " + udd);
    }

    @Override
    public JSExpr resolveIntroduction(IntroduceVar var) {
        if (this.introductions.containsKey(var)) {
            return this.introductions.get(var);
        }
        throw new RuntimeException("No introduction for " + var);
    }

    @Override
    public void cacheResult() {
        this.cacheResult = true;
    }

    @Override
    public boolean shouldCacheResult() {
        return this.cacheResult;
    }

    @Override
    public <T> T stateFor(Class<?> clz, String name) {
        Map<String, Object> cache = this.moduleCaches.get(clz);
        if (cache == null || !cache.containsKey(name)) {
            throw new InvalidUsageException("there is no value for " + clz);
        }
        return (T)cache.get(name);
    }

    @Override
    public <T> void cacheFor(Class<?> clz, String name, T o) {
        if (!this.moduleCaches.containsKey(clz)) {
            this.moduleCaches.put(clz, new HashMap());
        }
        Map<String, Object> cache = this.moduleCaches.get(clz);
        cache.put(name, o);
    }

    @Override
    public Map<Class<?>, Map<String, Object>> moduleCaches() {
        return this.moduleCaches;
    }
}

