/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.NumericLiteral;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.ApplyExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.CastExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.CheckTypeGeneratorJS;
import org.flasck.flas.compiler.jsgen.ExprGeneratorModule;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.TypeExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.form.JSCurryArg;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSThis;
import org.flasck.flas.parsedForm.AnonymousVar;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.CheckTypeExpr;
import org.flasck.flas.parsedForm.CurrentContainer;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.MakeAcor;
import org.flasck.flas.parsedForm.MakeSend;
import org.flasck.flas.parsedForm.Messages;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TemplateNestedField;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.parsedForm.TypeExpr;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.ResultAware;
import org.zinutils.exceptions.NotImplementedException;

public class ExprGeneratorJS
extends LeafAdapter
implements ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private final JSBlockCreator block;
    private final boolean isExpectation;
    private static Iterable<ExprGeneratorModule> modules = null;

    public ExprGeneratorJS(JSFunctionState state, NestedVisitor nv, JSBlockCreator block, boolean isExpectation) {
        this.state = state;
        this.sv = nv;
        this.isExpectation = isExpectation;
        if (block == null) {
            throw new NullPointerException("Cannot have a null block");
        }
        this.block = block;
        nv.push(this);
    }

    @Override
    public void visitMakeSend(MakeSend expr) {
        new ApplyExprGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitMakeAcor(MakeAcor expr) {
        new ApplyExprGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitCurrentContainer(CurrentContainer expr, boolean isObjState, boolean wouldWantState) {
        this.sv.result(this.state.container(expr.type.name()));
    }

    @Override
    public void visitCheckTypeExpr(CheckTypeExpr expr) {
        new CheckTypeGeneratorJS(this.state, this.sv, this.block, this.isExpectation);
    }

    @Override
    public void visitApplyExpr(ApplyExpr expr) {
        new ApplyExprGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitTypeExpr(TypeExpr expr) {
        new TypeExprGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitCastExpr(CastExpr expr) {
        new CastExprGeneratorJS(this.state, this.sv, this.block, this.isExpectation);
    }

    @Override
    public void visitMessages(Messages msgs) {
        new ApplyExprGeneratorJS(this.state, this.sv, this.block);
    }

    @Override
    public void visitNumericLiteral(NumericLiteral expr) {
        this.sv.result(this.block.literal(expr.text));
    }

    @Override
    public void visitStringLiteral(StringLiteral expr) {
        this.sv.result(this.block.string(expr.text));
    }

    @Override
    public void visitUnresolvedVar(UnresolvedVar var, int nargs) {
        RepositoryEntry defn = var.defn();
        if (defn == null) {
            throw new RuntimeException("var " + var + " was still not resolved");
        }
        this.generateFnOrCtor(defn, this.handleBuiltinName(defn), nargs);
    }

    @Override
    public void visitTypeReference(TypeReference tr, boolean expectPolys, int exprNargs) {
        if (exprNargs == -1) {
            return;
        }
        RepositoryEntry defn = (RepositoryEntry)((Object)tr.namedDefn());
        if (defn == null) {
            throw new RuntimeException("var " + tr + " was still not resolved");
        }
        this.generateFnOrCtor(defn, this.handleBuiltinName(defn), exprNargs);
    }

    @Override
    public void visitAnonymousVar(AnonymousVar var) {
        if (this.isExpectation) {
            this.sv.result(this.block.introduceVar(null));
        } else {
            this.sv.result(new JSCurryArg());
        }
    }

    @Override
    public void visitIntroduceVar(IntroduceVar var) {
        if (!this.isExpectation) {
            throw new NotImplementedException("Cannot introduce vars here");
        }
        JSExpr jsv = this.block.introduceVar(var.var);
        this.state.addIntroduction(var, jsv);
        this.sv.result(jsv);
    }

    @Override
    public void visitUnresolvedOperator(UnresolvedOperator operator, int nargs) {
        RepositoryEntry defn = operator.defn();
        if (defn == null) {
            throw new RuntimeException("operator " + operator + " has not been resolved");
        }
        this.generateFnOrCtor(defn, this.resolveOpName(operator.op, nargs), nargs);
    }

    private void generateFnOrCtor(RepositoryEntry defn, String myName, int nargs) {
        if (defn instanceof FunctionDefinition) {
            FunctionDefinition fn = (FunctionDefinition)defn;
            if (nargs == 0) {
                this.makeFunctionClosure(fn.hasState(), fn.name(), myName, fn.argCount());
            } else if ("MakeTuple".equals(myName)) {
                this.sv.result(null);
            } else {
                this.sv.result(this.block.pushFunction(myName, fn.name(), nargs));
            }
        } else if (defn instanceof StandaloneMethod) {
            if (nargs == 0) {
                StandaloneMethod fn = (StandaloneMethod)defn;
                this.makeFunctionClosure(false, fn.name(), myName, fn.argCount());
            } else {
                this.sv.result(this.block.pushFunction(myName, (FunctionName)defn.name(), nargs));
            }
        } else if (defn instanceof ObjectMethod) {
            if (nargs == 0) {
                ObjectMethod fn = (ObjectMethod)defn;
                this.makeFunctionClosure(true, null, myName, fn.argCount());
            } else {
                this.sv.result(this.block.pushFunction(myName, (FunctionName)defn.name(), nargs));
            }
        } else if (defn instanceof StructDefn) {
            StructDefn sd = (StructDefn)defn;
            if (nargs == 0 && sd.argCount() == 0) {
                this.sv.result(this.block.structConst(sd.name()));
            } else if (myName.equals("MakeArray") || sd.argCount() == nargs) {
                this.sv.result(null);
            } else if (nargs > 0) {
                this.sv.result(this.block.pushConstructor(defn.name(), myName));
            } else {
                this.sv.result(this.block.curry(false, sd.argCount(), this.block.pushConstructor(defn.name(), myName)));
            }
        } else if (defn instanceof HandlerImplements) {
            HandlerImplements hi = (HandlerImplements)defn;
            if (nargs == 0 && hi.argCount() == 0) {
                ArrayList<JSExpr> args = new ArrayList<JSExpr>();
                args.add(this.state.container(hi.getParent().name()));
                this.sv.result(this.block.createObject(defn.name(), args));
            } else if (nargs > 0) {
                this.sv.result(this.block.pushConstructor(defn.name(), myName));
            } else {
                this.sv.result(this.block.curry(false, hi.argCount(), this.block.pushConstructor(defn.name(), myName)));
            }
        } else if (defn instanceof VarPattern) {
            this.sv.result(this.block.boundVar(((VarPattern)defn).var));
        } else if (defn instanceof TypedPattern) {
            this.sv.result(this.block.boundVar(((TypedPattern)defn).var.var));
        } else if (defn instanceof HandlerLambda) {
            this.sv.result(this.block.lambda((HandlerLambda)defn));
        } else if (defn instanceof StructField) {
            StructField sf = (StructField)defn;
            this.sv.result(this.block.loadField(this.state.container(sf.container.name()), sf.name));
        } else if (defn instanceof TemplateNestedField) {
            TemplateNestedField tnf = (TemplateNestedField)defn;
            StructField sf = tnf.getField();
            JSExpr from = this.state.templateObj().get(tnf.name().var);
            if (sf != null) {
                this.sv.result(this.block.loadField(from, sf.name));
            } else {
                this.sv.result(from);
            }
        } else if (defn instanceof RequiresContract) {
            RequiresContract rc = (RequiresContract)defn;
            this.sv.result(this.block.contractByVar(this.state.container(rc.getParent().name()), rc.referAsVar));
        } else if (defn instanceof Provides) {
            Provides p = (Provides)defn;
            this.sv.result(this.block.contractByVar(this.state.container(p.getParent().name()), p.referAsVar));
        } else if (defn instanceof ObjectContract) {
            ObjectContract oc = (ObjectContract)defn;
            this.sv.result(this.block.member(oc.implementsType().namedDefn().name(), oc.varName().var));
        } else if (defn instanceof TupleMember) {
            this.makeFunctionClosure(false, ((TupleMember)defn).name(), myName, 0);
        } else if (defn instanceof UnitDataDeclaration) {
            this.handleUnitTestData((UnitDataDeclaration)defn);
        } else if (defn instanceof IntroduceVar) {
            this.sv.result(this.block.fromIntroduction(this.state.resolveIntroduction((IntroduceVar)defn)));
        } else if (defn instanceof ObjectCtor) {
            ObjectCtor oc = (ObjectCtor)defn;
            int expArgs = oc.argCountIncludingContracts();
            JSExpr fn = this.block.callStatic(oc.name(), expArgs + 1);
            if (nargs == 0) {
                JSExpr call = expArgs > 0 ? this.block.curry(false, expArgs + 1, fn) : this.block.closure(false, fn, this.state.container(new PackageName("_DisplayUpdater")));
                this.sv.result(call);
            } else {
                this.sv.result(fn);
            }
        } else {
            for (ExprGeneratorModule m : modules) {
                if (!m.generateFnOrCtor(this.sv, this.state, this.block, defn, myName, nargs)) continue;
                return;
            }
            throw new NotImplementedException("cannot generate fn for " + defn);
        }
    }

    private void handleUnitTestData(UnitDataDeclaration udd) {
        this.sv.result(this.state.resolveMock(this.block, udd));
    }

    private void makeFunctionClosure(boolean hasState, FunctionName fnName, String func, int expArgs) {
        JSExpr[] args = hasState ? new JSExpr[]{this.block.pushFunction(func, fnName, expArgs), new JSThis()} : new JSExpr[]{this.block.pushFunction(func, fnName, expArgs)};
        if (expArgs > 0) {
            this.sv.result(this.block.curry(hasState, expArgs, args));
        } else {
            this.sv.result(this.block.closure(hasState, args));
        }
    }

    private String handleBuiltinName(RepositoryEntry defn) {
        NameOfThing name = defn.name();
        if (name instanceof FunctionName && ((FunctionName)name).inContext instanceof PackageName && ((PackageName)((FunctionName)name).inContext).isBuiltin()) {
            String un = name.uniqueName();
            if (un.equals("length")) {
                un = "arr_length";
            }
            return "FLBuiltin." + un;
        }
        if (defn instanceof ObjectMethod) {
            return ((FunctionName)name).jsPName();
        }
        if (defn instanceof LogicHolder && ((LogicHolder)((Object)defn)).hasState()) {
            return ((FunctionName)name).jsPName();
        }
        return name.jsName();
    }

    private String resolveOpName(String op, int nargs) {
        switch (op) {
            case "&&": {
                return "FLBuiltin.boolAnd";
            }
            case "||": {
                return "FLBuiltin.boolOr";
            }
            case "!": {
                return "FLBuiltin.not";
            }
            case "==": {
                return "FLBuiltin.isEqual";
            }
            case "<>": {
                return "FLBuiltin.isNotEqual";
            }
            case ">=": {
                return "FLBuiltin.greaterEqual";
            }
            case ">": {
                return "FLBuiltin.greaterThan";
            }
            case "<=": {
                return "FLBuiltin.lessEqual";
            }
            case "<": {
                return "FLBuiltin.lessThan";
            }
            case "+": {
                return "FLBuiltin.plus";
            }
            case "-": {
                if (nargs == 2) {
                    return "FLBuiltin.minus";
                }
                return "FLBuiltin.unaryMinus";
            }
            case "*": {
                return "FLBuiltin.mul";
            }
            case "/": {
                return "FLBuiltin.div";
            }
            case "%": {
                return "FLBuiltin.mod";
            }
            case "++": {
                return "FLBuiltin.concat";
            }
            case "[]": {
                if (nargs == 0) {
                    return "Nil";
                }
                return "MakeArray";
            }
            case "()": {
                return "MakeTuple";
            }
            case "{}": {
                return "MakeHash";
            }
            case ":": {
                return "FLBuiltin.hashPair";
            }
        }
        throw new RuntimeException("There is no operator " + op);
    }

    @Override
    public void result(Object r) {
        this.sv.result((JSExpr)r);
    }

    static {
        modules = ServiceLoader.load(ExprGeneratorModule.class);
    }
}

