/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.compiler.jsgen.ExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.parsedForm.TargetZone;
import org.flasck.flas.parsedForm.ut.UnitTestEvent;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;

public class DoUTEventGeneratorJS
extends LeafAdapter
implements ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private final JSBlockCreator block;
    private final JSExpr runner;
    private final List<JSExpr> args = new ArrayList<JSExpr>();

    public DoUTEventGeneratorJS(JSFunctionState state, NestedVisitor sv, JSBlockCreator block, JSExpr runner) {
        this.state = state;
        this.sv = sv;
        this.block = block;
        this.runner = runner;
        sv.push(this);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        new ExprGeneratorJS(this.state, this.sv, this.block, true);
    }

    @Override
    public void result(Object r) {
        this.args.add((JSExpr)r);
    }

    @Override
    public void leaveUnitTestEvent(UnitTestEvent e) {
        if (this.args.size() != 2) {
            throw new RuntimeException("expected card & event");
        }
        this.block.assertable(this.runner, "event", this.args.get(0), DoUTEventGeneratorJS.makeSelector(this.block, e.targetZone), this.args.get(1));
        this.sv.result(null);
    }

    public static JSExpr makeSelector(JSBlockCreator block, TargetZone targetZone) {
        ArrayList<JSExpr> al = new ArrayList<JSExpr>();
        for (int i = 0; i < targetZone.fields.size(); ++i) {
            String ty = targetZone.types().get(i).toString().toLowerCase();
            JSExpr je = DoUTEventGeneratorJS.makeEventZone(block, targetZone.fields.get(i));
            if (je == null) continue;
            al.add(block.makeEventZone(block.string(ty), je));
        }
        return block.makeArray(al);
    }

    public static JSExpr makeEventZone(JSBlockCreator block, Object o) {
        if (o instanceof String) {
            return block.string((String)o);
        }
        if (o instanceof TargetZone.Qualifier) {
            return null;
        }
        return block.literal(Integer.toString((Integer)o));
    }
}

