/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.compiler.jsgen.ExprGeneratorJS;
import org.flasck.flas.compiler.jsgen.JSFunctionState;
import org.flasck.flas.compiler.jsgen.JSGenerator;
import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.form.JSCurryArg;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.MakeAcor;
import org.flasck.flas.parsedForm.MakeSend;
import org.flasck.flas.parsedForm.Messages;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.WithTypeSignature;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.ExpressionChecker;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class ApplyExprGeneratorJS
extends LeafAdapter
implements ResultAware {
    private final JSFunctionState state;
    private final NestedVisitor sv;
    private final JSBlockCreator block;
    private final List<JSExpr> stack = new ArrayList<JSExpr>();

    public ApplyExprGeneratorJS(JSFunctionState state, NestedVisitor nv, JSBlockCreator block) {
        this.state = state;
        this.sv = nv;
        if (block == null) {
            throw new NullPointerException("Cannot have a null block");
        }
        this.block = block;
        nv.push(this);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        new ExprGeneratorJS(this.state, this.sv, this.block, false);
    }

    @Override
    public void leaveApplyExpr(ApplyExpr expr) {
        if (expr.args.isEmpty()) {
            if (this.stack.size() != 1) {
                throw new NotImplementedException("stack should now have size 1");
            }
            this.sv.result(this.stack.remove(0));
        } else {
            WithTypeSignature defn = this.figureDefn(expr.fn);
            if (defn != null) {
                this.makeClosure(defn, defn.argCount());
            }
        }
    }

    private WithTypeSignature figureDefn(Object fn) {
        if (fn instanceof UnresolvedVar) {
            return (WithTypeSignature)((Object)((UnresolvedVar)fn).defn());
        }
        if (fn instanceof ApplyExpr) {
            WithTypeSignature defn = (WithTypeSignature)((Object)((UnresolvedVar)((ApplyExpr)fn).fn).defn());
            this.makeClosure(null, defn.argCount() - ((ApplyExpr)fn).args.size());
            return null;
        }
        if (fn instanceof TypeReference) {
            return (WithTypeSignature)((Object)((TypeReference)fn).namedDefn());
        }
        if (fn instanceof UnresolvedOperator) {
            return (WithTypeSignature)((Object)((UnresolvedOperator)fn).defn());
        }
        if (fn instanceof MakeSend) {
            return (MakeSend)fn;
        }
        if (fn instanceof MemberExpr) {
            if ((fn = ((MemberExpr)fn).converted()) instanceof MakeSend) {
                return (MakeSend)fn;
            }
            if (fn instanceof MakeAcor) {
                return (MakeAcor)fn;
            }
            if (fn instanceof UnresolvedVar) {
                return (WithTypeSignature)((Object)((UnresolvedVar)fn).defn());
            }
            if (fn instanceof TypeReference) {
                return (WithTypeSignature)((Object)((TypeReference)fn).namedDefn());
            }
            if (fn instanceof ApplyExpr) {
                WithTypeSignature defn = (WithTypeSignature)((Object)((UnresolvedVar)((ApplyExpr)fn).fn).defn());
                this.makeClosure(null, defn.argCount() - ((ApplyExpr)fn).args.size());
                return null;
            }
            throw new NotImplementedException("unknown operator type: " + fn.getClass());
        }
        if (fn instanceof MakeAcor) {
            return (MakeAcor)fn;
        }
        throw new NotImplementedException("unknown operator type: " + fn.getClass());
    }

    @Override
    public void leaveMessages(Messages msgs) {
        this.sv.result(this.block.makeArray(this.stack.toArray(new JSExpr[this.stack.size()])));
    }

    private void makeClosure(WithTypeSignature defn, int expArgs) {
        if (defn instanceof HandlerImplements) {
            HandlerImplements hi = (HandlerImplements)defn;
            if (hi.getParent() != null) {
                if (this.state.hasContainer(hi.getParent().name())) {
                    ++expArgs;
                    this.stack.add(1, this.state.container(hi.getParent().name()));
                } else {
                    JSExpr mockCard = this.stack.remove(1);
                    this.stack.add(1, this.block.unmock(mockCard));
                }
            }
        } else if (defn instanceof ObjectCtor) {
            int reqcnt = ((ObjectActionHandler)((Object)defn)).getObject().contracts.size();
            this.stack.add(1, this.state.container(new PackageName("_DisplayUpdater")));
            if (reqcnt > 0) {
                for (int i = 0; i < expArgs; ++i) {
                    this.stack.add(2, new JSCurryArg());
                }
            }
            ++expArgs;
            expArgs += reqcnt;
        }
        if (defn instanceof FunctionDefinition && defn.name().uniqueName().equals("()")) {
            this.stack.remove(0);
            this.sv.result(this.block.makeTuple(this.stack.toArray(new JSExpr[this.stack.size()])));
        } else if (defn instanceof StructDefn && defn.name().uniqueName().equals("Nil")) {
            this.stack.remove(0);
            this.sv.result(this.block.makeArray(this.stack));
        } else if (defn instanceof StructDefn && defn.name().uniqueName().equals("Hash")) {
            this.stack.remove(0);
            this.sv.result(this.block.makeHash(this.stack));
        } else if (defn instanceof StructDefn && this.stack.size() > 1) {
            NameOfThing fn = defn.name();
            if (fn.uniqueName().equals("Error")) {
                fn = new SolidName(new PackageName(true), "FLError");
            }
            if (this.stack.size() == expArgs + 2) {
                this.stack.remove(0);
                JSExpr hash = this.stack.remove(this.stack.size() - 1);
                JSExpr basic = this.block.structArgs(fn, this.stack.toArray(new JSExpr[this.stack.size()]));
                this.sv.result(this.block.applyHash(basic, hash));
            } else if (this.stack.size() == expArgs + 1) {
                this.stack.remove(0);
                this.sv.result(this.block.structArgs(fn, this.stack.toArray(new JSExpr[this.stack.size()])));
            } else {
                if (this.stack.size() > expArgs + 2) {
                    throw new CantHappenException("this should have been caught by the typechecker: stack has " + this.stack.size() + " and we expected " + (expArgs + 2) + " in " + defn);
                }
                this.sv.result(this.block.curry(false, expArgs, this.stack.toArray(new JSExpr[this.stack.size()])));
            }
        } else {
            JSExpr call;
            boolean wantObject = false;
            if (defn instanceof LogicHolder && ((LogicHolder)((Object)defn)).hasState()) {
                wantObject = true;
            }
            JSExpr[] args = new JSExpr[this.stack.size()];
            ArrayList<JSGenerator.XCArg> xcs = new ArrayList<JSGenerator.XCArg>();
            int k = 0;
            boolean explicit = false;
            for (JSExpr arg : this.stack) {
                if (arg instanceof JSCurryArg) {
                    explicit = true;
                } else {
                    xcs.add(new JSGenerator.XCArg(k, arg));
                }
                args[k++] = arg;
            }
            if (explicit) {
                call = this.block.xcurry(wantObject, expArgs, xcs);
            } else if (this.stack.size() < expArgs + 1) {
                call = this.block.curry(wantObject, expArgs, args);
            } else {
                call = this.block.closure(wantObject, args);
                if (!wantObject || this.state.ocmsgs() != null) {
                    // empty if block
                }
            }
            this.sv.result(call);
        }
    }

    @Override
    public void leaveMakeSend(MakeSend expr) {
        int expsize = 1;
        if (expr.handler != null) {
            ++expsize;
        }
        if (expr.handlerName != null) {
            ++expsize;
        }
        if (this.stack.size() != expsize) {
            throw new NotImplementedException("badly formed stack in makeSend");
        }
        JSExpr obj = this.stack.remove(0);
        JSExpr handler = expr.handler == null ? null : this.stack.remove(0);
        JSExpr handlerName = expr.handlerName == null ? null : this.stack.remove(0);
        this.sv.result(this.block.makeSend(expr.sendMeth.name, obj, expr.nargs, handler, handlerName));
    }

    @Override
    public void leaveMakeAcor(MakeAcor expr) {
        if (this.stack.size() != 1) {
            throw new NotImplementedException();
        }
        JSExpr obj = this.stack.remove(0);
        this.sv.result(this.block.makeAcor(expr.acorMeth, obj, expr.nargs));
    }

    @Override
    public void result(Object r) {
        if (!(r instanceof ExpressionChecker.IgnoreMe)) {
            this.stack.add((JSExpr)r);
        }
    }
}

