/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.FileContentObject;
import org.flasck.jvm.ziniki.PackageSources;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.FileNameComparator;
import org.zinutils.utils.FileUtils;

public class FileBasedSources
implements PackageSources {
    private final File dir;
    private final List<ContentObject> fls = new ArrayList<ContentObject>();
    private final List<ContentObject> uts = new ArrayList<ContentObject>();
    private final List<ContentObject> fas = new ArrayList<ContentObject>();
    private final List<ContentObject> sts = new ArrayList<ContentObject>();
    private final List<ContentObject> mjs = new ArrayList<ContentObject>();
    private final List<ContentObject> ljs = new ArrayList<ContentObject>();
    private final List<ContentObject> tjs = new ArrayList<ContentObject>();
    private final List<ContentObject> webs = new ArrayList<ContentObject>();

    public FileBasedSources(File dir, List<File> webs) {
        this.dir = dir;
        this.collect(this.fls, dir, "*.fl");
        this.collect(this.uts, dir, "*.ut");
        this.collect(this.fas, dir, "*.fa");
        this.collect(this.sts, dir, "*.st");
        for (File f : webs) {
            this.webs.add((ContentObject)new FileContentObject(f));
        }
    }

    public String getPackageName() {
        return this.dir.getName();
    }

    private void collect(List<ContentObject> into, File dir, String patt) {
        List files = FileUtils.findFilesMatching((File)dir, (String)patt);
        files.sort(new FileNameComparator());
        for (File f : files) {
            into.add((ContentObject)new FileContentObject(f));
        }
    }

    public List<ContentObject> webs() {
        return this.webs;
    }

    public List<ContentObject> sources() {
        return this.fls;
    }

    public List<ContentObject> unitTests() {
        return this.uts;
    }

    public List<ContentObject> assemblies() {
        return this.fas;
    }

    public List<ContentObject> systemTests() {
        return this.sts;
    }

    public List<ContentObject> corejs() {
        return this.mjs;
    }

    public List<ContentObject> livejs() {
        return this.ljs;
    }

    public List<ContentObject> mockjs() {
        return this.tjs;
    }

    public List<ContentObject> flims() {
        throw new NotImplementedException("I don't think this makes sense in this context");
    }
}

