/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.parsedForm.FunctionConstness;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.repository.FunctionGroup;
import org.flasck.flas.repository.FunctionGroups;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.Traverser;

public class FigureFunctionConstness
extends LeafAdapter {
    private final Traverser traverser = new Traverser(this);
    private boolean needsState;
    private List<NameOfThing> depends;

    public void processAll(FunctionGroups ordering) {
        TreeMap<String, FunctionConstness> map = new TreeMap<String, FunctionConstness>();
        for (FunctionGroup grp : ordering) {
            for (LogicHolder f : grp.functions()) {
                map.put(f.name().uniqueName(), this.process(f));
            }
        }
        for (FunctionGroup grp : ordering) {
            for (LogicHolder f : grp.functions()) {
                String name = f.name().uniqueName();
                FunctionConstness fc = (FunctionConstness)map.get(name);
                if (fc.depends != null && this.hasStateDependencies(map, new ArrayList<String>(), fc.depends)) {
                    fc = new FunctionConstness("dependencies use state");
                }
                f.setConstness(fc);
            }
        }
    }

    private boolean hasStateDependencies(Map<String, FunctionConstness> map, List<String> already, List<NameOfThing> tocheck) {
        for (NameOfThing n : tocheck) {
            String name = n.uniqueName();
            if (already.contains(name)) {
                return false;
            }
            already.add(name);
            FunctionConstness fc = map.get(name);
            if (fc == null) continue;
            if (fc.reason != null) {
                return true;
            }
            if (fc.depends == null || !this.hasStateDependencies(map, already, tocheck)) continue;
            return true;
        }
        return false;
    }

    public FunctionConstness process(LogicHolder f) {
        this.needsState = false;
        this.depends = new ArrayList<NameOfThing>();
        if (f.hasArgs()) {
            return new FunctionConstness("hasArgs");
        }
        if (f.hasState()) {
            this.traverser.visitLogic(f);
            if (this.needsState) {
                return new FunctionConstness("needsState");
            }
        }
        return new FunctionConstness(this.depends);
    }

    @Override
    public void visitUnresolvedVar(UnresolvedVar var, int nargs) {
        if (var.defn() instanceof StructField) {
            this.needsState = true;
        } else if (var.defn() instanceof LogicHolder) {
            this.depends.add(var.defn().name());
        }
    }
}

