/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.flasck.flas.Configuration;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.UnitTestFileName;
import org.flasck.flas.compiler.CardDataListener;
import org.flasck.flas.compiler.CompileUnit;
import org.flasck.flas.compiler.CompilerAssembler;
import org.flasck.flas.compiler.FigureFunctionConstness;
import org.flasck.flas.compiler.FileBasedSources;
import org.flasck.flas.compiler.ParsingPhase;
import org.flasck.flas.compiler.PhaseTo;
import org.flasck.flas.compiler.TaskQueue;
import org.flasck.flas.compiler.jsgen.JSGenerator;
import org.flasck.flas.compiler.jsgen.packaging.JSEnvironment;
import org.flasck.flas.compiler.jsgen.packaging.JSUploader;
import org.flasck.flas.compiler.modules.CompilerComplete;
import org.flasck.flas.compiler.modules.ParserModule;
import org.flasck.flas.compiler.templates.EventBuilder;
import org.flasck.flas.compiler.templates.EventTargetZones;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.ErrorResultException;
import org.flasck.flas.lifting.RepositoryLifter;
import org.flasck.flas.method.ConvertRepositoryMethods;
import org.flasck.flas.parsedForm.EventHolder;
import org.flasck.flas.parsedForm.assembly.ApplicationAssembly;
import org.flasck.flas.parsedForm.assembly.Assembly;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.ut.UnitTestPackage;
import org.flasck.flas.parser.assembly.BuildAssembly;
import org.flasck.flas.parser.ut.ConsumeDefinitions;
import org.flasck.flas.patterns.PatternAnalyzer;
import org.flasck.flas.repository.AssemblyVisitor;
import org.flasck.flas.repository.FunctionGroups;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.StackVisitor;
import org.flasck.flas.repository.flim.FlimReader;
import org.flasck.flas.repository.flim.FlimTop;
import org.flasck.flas.repository.flim.FlimWriter;
import org.flasck.flas.resolver.RepositoryResolver;
import org.flasck.flas.tc3.TypeChecker;
import org.flasck.flas.tc3.TypeDumper;
import org.flasck.flas.testrunner.JSRunner;
import org.flasck.flas.testrunner.JVMRunner;
import org.flasck.flas.testrunner.TestResultWriter;
import org.flasck.jvm.J;
import org.flasck.jvm.assembly.FLASAssembler;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.FileContentObject;
import org.flasck.jvm.ziniki.MemoryContentObject;
import org.flasck.jvm.ziniki.PackageSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.splitter.ConcreteMetaData;
import org.ziniki.splitter.SplitMetaData;
import org.ziniki.splitter.Splitter;
import org.zinutils.bytecode.BCEClassLoader;
import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.NoSuchDirectoryException;
import org.zinutils.graphs.DirectedAcyclicGraph;
import org.zinutils.utils.FileUtils;

public class FLASCompiler
implements CompileUnit {
    static final Logger logger = LoggerFactory.getLogger((String)"Compiler");
    private final Configuration config;
    private final ErrorReporter errors;
    private final Repository repository;
    private final Splitter splitter;
    private final ServiceLoader<ParserModule> modules;
    private final ServiceLoader<CompilerComplete> completeModules;
    private final List<URI> brokenUris = new ArrayList<URI>();
    private TaskQueue tasks;
    private File cardsFolder;
    private DirectedAcyclicGraph<String> pkgs;
    private JSEnvironment jse;
    private Map<EventHolder, EventTargetZones> eventMap;
    private ByteCodeEnvironment bce;
    private JSUploader uploader;
    private CardDataListener cardDataListener;
    private Map<URI, String> textCache = new TreeMap<URI, String>();

    public FLASCompiler(Configuration config, ErrorReporter errors, Repository repository, CardDataListener cardDataListener) {
        logger.info("initializing FLASCompiler");
        this.config = config;
        this.errors = errors;
        this.repository = repository;
        this.splitter = this.config.usesplitter ? new Splitter(x -> errors.message(new InputPosition(x.file, 0, 0, null, x.text), x.message)) : null;
        this.modules = ServiceLoader.load(ParserModule.class);
        this.completeModules = ServiceLoader.load(CompilerComplete.class);
        this.cardDataListener = cardDataListener;
    }

    public BCEClassLoader classLoader() {
        return new BCEClassLoader(this.bce);
    }

    public void uploader(JSUploader loader) {
        this.uploader = loader;
    }

    public void taskQueue(TaskQueue tasks) {
        this.tasks = tasks;
    }

    public void setCardsFolder(File cardsFolder) {
        this.cardsFolder = cardsFolder;
    }

    public void lspLoadFLIM(URI uri) {
        logger.info("lspLoadFLIM for workspace " + uri);
        this.errors.beginPhase1(uri);
        this.loadFLIMFromFiles();
        this.errors.doneProcessing(this.brokenUris);
    }

    public boolean loadFLIMFromFiles() {
        LoadBuiltins.applyTo(this.errors, this.repository);
        this.pkgs = new DirectedAcyclicGraph();
        FlimReader reader = new FlimReader(this.errors, this.repository);
        for (File dir : this.config.includeFrom) {
            reader.read(this.pkgs, dir, this.config.inputs);
            if (!this.errors.hasErrors()) continue;
            return true;
        }
        reader.read(this.pkgs, this.config.writeFlim, this.config.inputs);
        return this.errors.hasErrors();
    }

    public void loadFLIMFromContentStore() {
        LoadBuiltins.applyTo(this.errors, this.repository);
        this.pkgs = new DirectedAcyclicGraph();
        HashSet<FlimTop> importers = new HashSet<FlimTop>();
        FlimReader reader = new FlimReader(this.errors, this.repository);
        if (this.config.dependencies != null) {
            for (PackageSources ps : this.config.dependencies) {
                if (ps.flims() == null) continue;
                for (ContentObject co : ps.flims()) {
                    importers.add(reader.read(this.pkgs, ps.getPackageName(), co));
                }
            }
        }
        if (this.errors.hasErrors()) {
            return;
        }
        for (FlimTop ft : importers) {
            this.repository.selectPackage(ft.pkgName());
            ft.resolve();
        }
    }

    public PackageSources processInputFromDirectory(File input) throws ErrorResultException {
        if (!input.isDirectory()) {
            this.errors.message((InputPosition)null, "there is no input directory " + input);
            return null;
        }
        try {
            FileBasedSources sources = new FileBasedSources(input, this.config.webs);
            this.parse(sources);
            return sources;
        }
        catch (Throwable ex) {
            this.reportException(ex);
            throw new ErrorResultException(this.errors);
        }
    }

    public void splitWeb(File dir) {
        try {
            SplitMetaData md = this.splitter.split(dir);
            if (this.cardDataListener != null) {
                this.cardDataListener.provideWebData(md);
            }
            this.repository.webData(md);
        }
        catch (IOException ex) {
            this.errors.message((InputPosition)null, "error splitting: " + dir);
        }
    }

    public void splitWeb(ContentObject co) {
        try {
            File tmp = File.createTempFile("webdata", ".zip");
            FileOutputStream baos = new FileOutputStream(tmp);
            SplitMetaData md = this.splitter.split((OutputStream)baos, co.asStream());
            ((ConcreteMetaData)md).stream(tmp);
            this.repository.webData(md);
        }
        catch (IOException ex) {
            this.errors.message((InputPosition)null, "error splitting: " + co.key());
        }
    }

    public void parse(PackageSources sources) {
        File fi;
        File fi2;
        String inPkg = sources.getPackageName();
        this.checkPackageName(inPkg);
        System.out.println(" |" + inPkg);
        ParsingPhase flp = new ParsingPhase(this.errors, inPkg, this.repository, this.modules);
        logger.info("parsing fl");
        for (ContentObject f : sources.sources()) {
            fi2 = new File(f.key());
            if (!this.validateFileName(fi2)) continue;
            this.errors.track(fi2);
            flp.process(f);
        }
        logger.info("parsing ut");
        for (ContentObject f : sources.unitTests()) {
            fi2 = new File(f.key());
            if (!this.validateFileName(fi2)) continue;
            this.errors.track(fi2);
            String file = FileUtils.dropExtension((String)fi2.getName());
            UnitTestFileName utfn = new UnitTestFileName(new PackageName(inPkg), "_ut_" + file);
            UnitTestPackage utp = new UnitTestPackage(new InputPosition(file, 1, 0, null, ""), utfn);
            this.repository.unitTestPackage(this.errors, utp);
            ParsingPhase parser = new ParsingPhase(this.errors, utfn, new ConsumeDefinitions(this.errors, this.repository, utp));
            parser.process(f);
        }
        ParsingPhase fap = new ParsingPhase(this.errors, inPkg, new BuildAssembly(this.errors, this.repository));
        logger.info("parsing fa");
        for (ContentObject f : sources.assemblies()) {
            fi = new File(f.key());
            if (!this.validateFileName(fi)) continue;
            this.errors.track(fi);
            fap.process(f);
        }
        logger.info("parsing st");
        for (ContentObject f : sources.systemTests()) {
            fi = new File(f.key());
            if (!this.validateFileName(fi)) continue;
            this.errors.track(fi);
            String file = FileUtils.dropExtension((String)fi.getName());
            PackageName stfn = new PackageName(new PackageName(inPkg), "_st_" + file);
            SystemTest st = new SystemTest(stfn);
            this.repository.systemTest(this.errors, st);
            ParsingPhase parser = new ParsingPhase(this.errors, stfn, st, this.repository, this.modules);
            parser.process(f);
        }
    }

    private boolean validateFileName(File fi) {
        String n = fi.getName();
        if (!this.assertValidName(n)) {
            this.errors.message(new InputPosition(n, 0, 0, null, null), "illegal characters in file name");
            return false;
        }
        return true;
    }

    private boolean assertValidName(String n) {
        if (!Character.isLetter((n = FileUtils.dropExtension((String)n)).charAt(0))) {
            return false;
        }
        for (int i = 1; i < n.length(); ++i) {
            if (Character.isLetterOrDigit(n.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void parse(URI uri, String text) {
        logger.info("Compiling " + uri);
        this.errors.beginPhase1(uri);
        this.parseOne(uri, text);
        this.repository.done();
        this.errors.doneProcessing(this.brokenUris);
        this.tasks.readyWhenYouAre(uri, this);
    }

    private void parseOne(URI uri, String text) {
        FileContentObject co;
        this.repository.parsing(uri);
        File file = new File(uri.getPath());
        String inPkg = file.getParentFile().getName();
        String name = file.getName();
        String type = FileUtils.extension((String)name);
        if (text != null) {
            this.textCache.put(uri, text);
            co = new MemoryContentObject(file, text.getBytes());
        } else {
            co = new FileContentObject(file);
        }
        if (type == null) {
            this.errors.logMessage("could not compile " + inPkg + "/" + file);
            return;
        }
        switch (type) {
            case ".fl": {
                this.parseFL(file, inPkg, name, (ContentObject)co);
                break;
            }
            case ".ut": {
                break;
            }
            case ".st": {
                break;
            }
            case ".fa": {
                this.parseFA(file, inPkg, name, (ContentObject)co);
                break;
            }
            default: {
                this.errors.logMessage("could not compile " + inPkg + "/" + file);
            }
        }
    }

    private void parseFL(File file, String inPkg, String name, ContentObject fileCO) {
        ParsingPhase flp = new ParsingPhase(this.errors, inPkg, this.repository, this.modules);
        this.errors.logMessage("compiling " + name + " in " + inPkg);
        flp.process(fileCO);
    }

    private void parseFA(File file, String inPkg, String name, ContentObject fileCO) {
        ParsingPhase fap = new ParsingPhase(this.errors, inPkg, new BuildAssembly(this.errors, this.repository));
        this.errors.logMessage("compiling " + file.getName() + " in " + inPkg);
        fap.process(fileCO);
    }

    @Override
    public void attemptRest(URI uri) {
        logger.info("attempting to compile rest of files for " + uri);
        ArrayList<URI> broken = new ArrayList<URI>(this.brokenUris);
        for (URI b : broken) {
            if (b.equals(uri)) continue;
            if (this.textCache.containsKey(b)) {
                this.parseOne(b, this.textCache.get(b));
                continue;
            }
            this.parseOne(b, null);
        }
        if (!this.errors.getAllBrokenURIs().isEmpty()) {
            return;
        }
        if (this.cardsFolder != null && this.cardsFolder.isDirectory()) {
            this.splitWeb(this.cardsFolder);
        }
        this.errors.beginPhase2(uri);
        this.repository.clean();
        if (this.stage2(null)) {
            // empty if block
        }
        this.errors.doneProcessing(this.brokenUris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stage2(List<PackageSources> packages) {
        File dump = this.config.dumprepo();
        if (dump != null) {
            try {
                this.repository.dumpTo(dump);
            }
            catch (IOException ex) {
                System.out.println("Could not dump repository to " + dump);
            }
        }
        if (this.config.upto() == PhaseTo.PARSING) {
            return false;
        }
        logger.info("resolving");
        if (this.resolve()) {
            return true;
        }
        logger.info("lifting");
        FunctionGroups ordering = this.lift();
        logger.info("analyzing patterns");
        this.analyzePatterns();
        if (this.errors.hasErrors()) {
            return true;
        }
        logger.info("attempting to identify 'constant' functions");
        FigureFunctionConstness ffc = new FigureFunctionConstness();
        ffc.processAll(ordering);
        if (this.config.doTypeCheck) {
            logger.info("typechecking");
            this.doTypeChecking(ordering);
            if (this.errors.hasErrors()) {
                return true;
            }
            try {
                this.dumpTypes(this.config.writeTypesTo);
            }
            catch (FileNotFoundException ex) {
                this.errors.message((InputPosition)null, "cannot open file " + this.config.writeTypesTo);
                return true;
            }
            if (this.errors.hasErrors()) {
                return true;
            }
        }
        logger.info("converting methods");
        if (this.convertMethods()) {
            return true;
        }
        logger.info("building event maps");
        if (this.buildEventMaps()) {
            return true;
        }
        ListMap autolink = new ListMap();
        TreeSet<String> usedrefs = new TreeSet<String>();
        FlimWriter writer = null;
        ArrayList<Object> process = new ArrayList<Object>();
        if (this.config.flimdir() != null) {
            writer = new FlimWriter(this.repository, this.config.flimdir());
            for (PackageSources f : packages) {
                String pk;
                int x;
                Iterator<Object> pn = f.getPackageName();
                process.add(pn);
                if (!f.unitTests().isEmpty()) {
                    x = ((String)((Object)pn)).lastIndexOf(".") + 1;
                    pk = ((String)((Object)pn)).substring(x);
                    String up = pn + "._ut_" + pk;
                    process.add(up);
                    autolink.add((Object)up, pn);
                }
                if (f.systemTests().isEmpty()) continue;
                x = ((String)((Object)pn)).lastIndexOf(".") + 1;
                pk = ((String)((Object)pn)).substring(x);
                String sp = pn + "._st_" + pk;
                process.add(sp);
                autolink.add((Object)sp, pn);
            }
        } else if (this.uploader != null) {
            writer = new FlimWriter(this.repository, this.uploader);
            for (PackageSources p : packages) {
                process.add(p.getPackageName());
            }
        }
        if (writer != null) {
            while (!process.isEmpty()) {
                String input = (String)process.remove(0);
                Set<String> refs = writer.export(input);
                if (refs == null) {
                    return true;
                }
                this.pkgs.ensure((Object)input);
                if (autolink.contains((Object)input)) {
                    for (String k : autolink.get((Object)input)) {
                        this.pkgs.ensure((Object)k);
                        this.pkgs.ensureLink((Object)input, (Object)k);
                    }
                }
                for (String s : refs) {
                    this.pkgs.ensure((Object)s);
                    this.pkgs.ensureLink((Object)input, (Object)s);
                }
                usedrefs.addAll(refs);
                refs.retainAll(process);
                if (refs.isEmpty()) continue;
                for (String s : refs) {
                    System.out.println("invalid order: package " + input + " depends on " + s + " which has not been processed");
                }
                return true;
            }
        }
        logger.info("generating code");
        if (this.generateCode(this.config, this.pkgs)) {
            return true;
        }
        HashMap<File, TestResultWriter> testWriters = new HashMap<File, TestResultWriter>();
        try {
            logger.info("running unit tests");
            if (this.runUnitTests(this.config, testWriters)) {
                boolean bl = true;
                return bl;
            }
            logger.info("running system tests");
            if (this.runSystemTests(this.config, testWriters)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            testWriters.values().forEach(w -> w.close());
        }
        if (this.config.genapps) {
            for (Assembly a : this.repository.getAssemblies()) {
                if (!(a instanceof ApplicationAssembly)) continue;
                File todir = FileUtils.combine((Object[])new Object[]{this.config.projectDir, "apps", a.name().uniqueName()});
                logger.info("build app for " + a + " in " + todir);
                FileUtils.cleanDirectory((File)todir);
                FileUtils.assertDirectory((File)todir);
                String idx = "index.html";
                if (this.config.html != null) {
                    idx = this.config.html;
                }
                File saveAs = new File(todir, idx);
                try (FileWriter fos = new FileWriter(saveAs);){
                    FLASAssembler asm = new FLASAssembler((Writer)fos);
                    this.generateHTML(asm, todir, a);
                }
                catch (IOException ex) {
                    System.err.println("could not save " + a.name().uniqueName() + " to " + saveAs);
                }
            }
        }
        for (CompilerComplete cc : this.completeModules) {
            cc.complete(this.errors, this.config, packages, this.bce, this.jse);
        }
        return false;
    }

    public boolean resolve() {
        RepositoryResolver resolver = new RepositoryResolver(this.errors, this.repository);
        this.repository.traverseWithImplementedMethods(resolver);
        return this.errors.hasErrors();
    }

    public FunctionGroups lift() {
        return new RepositoryLifter().lift(this.repository);
    }

    public void analyzePatterns() {
        StackVisitor sv = new StackVisitor();
        new PatternAnalyzer(this.errors, this.repository, sv);
        this.repository.traverseLifted(sv);
    }

    public void doTypeChecking(FunctionGroups ordering) {
        StackVisitor sv = new StackVisitor();
        new TypeChecker(this.errors, this.repository, sv);
        this.repository.traverseInGroups(sv, ordering);
    }

    public void dumpTypes(File ty) throws FileNotFoundException {
        if (ty != null) {
            OutputStream fos = ty.equals(this.config.projectDir) ? System.out : new FileOutputStream(ty);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(fos));
            TypeDumper dumper = new TypeDumper(pw);
            this.repository.traverse(dumper);
            pw.flush();
            if (fos != System.out) {
                pw.close();
            }
        }
    }

    public boolean convertMethods() {
        StackVisitor sv = new StackVisitor();
        new ConvertRepositoryMethods(sv, this.errors, this.repository);
        this.repository.traverseWithMemberFields(sv);
        return this.errors.hasErrors();
    }

    public boolean buildEventMaps() {
        StackVisitor stack = new StackVisitor();
        this.eventMap = new HashMap<EventHolder, EventTargetZones>();
        new EventBuilder(stack, this.eventMap);
        this.repository.traverse(stack);
        return this.errors.hasErrors();
    }

    public boolean generateCode(Configuration config, DirectedAcyclicGraph<String> pkgs) {
        this.jse = new JSEnvironment(config, this.errors, this.repository, pkgs);
        this.bce = new ByteCodeEnvironment();
        this.populateBCE(this.bce);
        StackVisitor jsstack = new StackVisitor();
        new JSGenerator(this.repository, this.jse, jsstack, this.eventMap);
        if (config.generateJS) {
            this.repository.traverseWithHSI(jsstack);
        }
        if (this.errors.hasErrors()) {
            return true;
        }
        if (config.generateJS) {
            this.saveJSE(null, this.jse, this.bce);
            this.jse.generate(this.bce);
            this.saveBCE(null, this.bce);
        }
        return this.errors.hasErrors();
    }

    public boolean runUnitTests(Configuration config, Map<File, TestResultWriter> writers) {
        if (!(config.generateJVM && config.unitjvm || config.generateJS && config.unitjs)) {
            return this.errors.hasErrors();
        }
        Map<String, String> allTemplates = this.extractTemplatesFromWebs();
        ClassLoader cl = this.getClass().getClassLoader();
        if (config.generateJVM && config.unitjvm) {
            cl = this.makeBCL(config);
            JVMRunner jvmRunner = new JVMRunner(config, this.repository, cl, allTemplates);
            jvmRunner.runAllUnitTests(writers);
            jvmRunner.reportErrors(this.errors);
        }
        if (config.generateJS && config.unitjs) {
            try {
                JSRunner jsRunner = new JSRunner(config, this.repository, this.jse, allTemplates, cl);
                jsRunner.runAllUnitTests(writers);
                jsRunner.reportErrors(this.errors);
                jsRunner.shutdown();
            }
            catch (Exception ex) {
                this.errors.reportException(ex);
            }
        }
        return this.errors.hasErrors();
    }

    public boolean runSystemTests(Configuration config, Map<File, TestResultWriter> writers) {
        if (!(config.generateJVM && config.systemjvm || config.generateJS && config.systemjs)) {
            return this.errors.hasErrors();
        }
        Map<String, String> allTemplates = this.extractTemplatesFromWebs();
        ClassLoader cl = this.getClass().getClassLoader();
        if (config.generateJVM && config.systemjvm) {
            cl = this.makeBCL(config);
            JVMRunner jvmRunner = new JVMRunner(config, this.repository, cl, allTemplates);
            jvmRunner.runAllSystemTests(writers);
            jvmRunner.reportErrors(this.errors);
        }
        if (config.generateJS && config.systemjs) {
            try {
                JSRunner jsRunner = new JSRunner(config, this.repository, this.jse, allTemplates, cl);
                jsRunner.runAllSystemTests(writers);
                jsRunner.reportErrors(this.errors);
                jsRunner.shutdown();
            }
            catch (Exception ex) {
                this.errors.reportException(ex);
            }
        }
        return this.errors.hasErrors();
    }

    private BCEClassLoader makeBCL(Configuration config) {
        BCEClassLoader bcl = new BCEClassLoader(this.bce);
        for (File f : config.includeFrom) {
            try {
                for (File g : FileUtils.findFilesMatching((File)f, (String)"*.jar")) {
                    bcl.addClassesFrom(g);
                }
            }
            catch (NoSuchDirectoryException ex) {
                logger.info("ignoring non-existent includeFrom directory " + f);
            }
        }
        for (String m : config.modules) {
            File md = new File(config.moduleDir, m);
            File mjd = new File(md, "jars");
            for (File f : FileUtils.findFilesMatching((File)mjd, (String)"*.jar")) {
                bcl.addClassesFrom(f);
            }
        }
        return bcl;
    }

    public void storeAssemblies(AssemblyVisitor storer) {
        if (this.jse != null) {
            this.repository.traverseAssemblies(this.config, this.errors, this.jse, this.bce, storer);
        }
    }

    public void generateHTML(FLASAssembler asm, File todir, Assembly assembly) {
        this.repository.traverseAssembly(this.config, this.errors, this.jse, this.bce, new CompilerAssembler(this.config, asm, todir), assembly);
    }

    private Map<String, String> extractTemplatesFromWebs() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        try {
            for (SplitMetaData smd : this.repository.allWebs()) {
                ZipInputStream zis = smd.processedZip();
                try {
                    ZipEntry ze;
                    while ((ze = zis.getNextEntry()) != null) {
                        if (!ze.getName().endsWith(".html")) continue;
                        ret.put(ze.getName().replace(".html", ""), new String(FileUtils.readAllStream((InputStream)zis), Charset.forName("UTF-8")));
                    }
                }
                finally {
                    if (zis == null) continue;
                    zis.close();
                }
            }
        }
        catch (IOException ex) {
            this.errors.message((InputPosition)null, "internal error reading templates from splitter");
        }
        return ret;
    }

    public void populateBCE(ByteCodeEnvironment bce) {
        ByteCodeCreator jr = bce.newClass("org.flasck.flas.testrunner.JVMRunner");
        jr.dontGenerate();
        jr.defineField(true, JavaInfo.Access.PUBLIC, J.FLEVALCONTEXT, "cxt");
        ByteCodeCreator card = bce.newClass(J.FLCARD);
        card.dontGenerate();
        card.defineField(false, JavaInfo.Access.PUBLIC, J.RENDERTREE, "_renderTree");
        card.defineField(true, JavaInfo.Access.PROTECTED, J.STRING, "_rootTemplate");
    }

    public void saveBCE(File jvmDir, ByteCodeEnvironment bce) {
        try {
            if (this.config.flimdir() != null) {
                Comparator invertor = (x, y) -> -x.compareTo((String)y);
                TreeSet<String> pkgs = new TreeSet<String>(invertor);
                for (File s : this.config.inputs) {
                    pkgs.add(s.getName());
                }
                TreeMap<String, ZipOutputStream> streams = new TreeMap<String, ZipOutputStream>();
                for (ByteCodeCreator c : bce.all()) {
                    String clname = c.getCreatedName();
                    String pkg = null;
                    for (String s : pkgs) {
                        if (!this.isInPackage(clname, s)) continue;
                        pkg = s;
                        break;
                    }
                    if (!this.isInPackage(clname, pkg) || clname.contains("_st_") || clname.contains("_ut_")) continue;
                    ZipOutputStream zos = (ZipOutputStream)streams.get(pkg);
                    if (zos == null) {
                        File f = new File(this.config.flimdir(), pkg + ".jar");
                        zos = new ZipOutputStream(new FileOutputStream(f));
                        streams.put(pkg, zos);
                    }
                    zos.putNextEntry(new ZipEntry(FileUtils.convertDottedToPath((String)clname).getPath() + ".class"));
                    zos.write(c.generate());
                }
                for (ZipOutputStream zos : streams.values()) {
                    zos.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errors.message((InputPosition)null, ex.toString());
        }
    }

    private boolean isInPackage(String clname, String pkg) {
        return pkg != null && (clname.startsWith(pkg) || pkg.equals("root.package") && clname.startsWith("org.flasck.jvm.builtin."));
    }

    public void saveJSE(File jsDir, JSEnvironment jse, ByteCodeEnvironment bce) {
        try {
            jse.generateCOs();
            if (this.uploader != null) {
                jse.upload(this.uploader);
            }
            if (this.config.flimdir() != null) {
                jse.saveCOsTo(this.config.flimdir());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errors.message((InputPosition)null, ex.toString());
        }
    }

    private void checkPackageName(String inPkg) {
        String[] bits;
        for (String s : bits = inPkg.split("\\.")) {
            if (Character.isLowerCase(s.charAt(0))) continue;
            throw new RuntimeException("Package must have valid package name");
        }
    }

    private void sendRepo() {
        try {
            String s;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.repository.dumpTo(pw);
            pw.close();
            LineNumberReader lnr = new LineNumberReader(new StringReader(sw.toString()));
            while ((s = lnr.readLine()) != null) {
                this.errors.logMessage(s);
            }
        }
        catch (Exception ex) {
            this.errors.logMessage("Error reading repo: " + ex);
        }
    }

    public void reportException(Throwable ex) {
        this.errors.reportException(ex);
    }
}

