/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.flasck.flas.Configuration;
import org.flasck.flas.compiler.FLASCompiler;
import org.flasck.flas.parsedForm.assembly.ApplicationAssembly;
import org.flasck.flas.parsedForm.assembly.Assembly;
import org.flasck.flas.repository.AssemblyVisitor;
import org.flasck.jvm.assembly.CardInitializer;
import org.flasck.jvm.assembly.FLASAssembler;
import org.flasck.jvm.ziniki.ContentObject;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.FileUtils;

public class CompilerAssembler
implements AssemblyVisitor {
    private final Configuration config;
    private final FLASAssembler asm;
    private final File jsdir;
    private final File cssdir;
    private List<String> inits = new ArrayList<String>();
    private List<String> css = new ArrayList<String>();
    private List<String> js = new ArrayList<String>();
    private List<ContentObject> temps = new ArrayList<ContentObject>();

    public CompilerAssembler(Configuration config, FLASAssembler asm, File todir) {
        this.config = config;
        this.asm = asm;
        this.jsdir = new File(todir, "js");
        this.cssdir = new File(todir, "css");
        FileUtils.cleanDirectory((File)this.jsdir);
        FileUtils.assertDirectory((File)this.jsdir);
        FileUtils.cleanDirectory((File)this.cssdir);
        FileUtils.assertDirectory((File)this.cssdir);
    }

    @Override
    public void visitAssembly(Assembly a) {
    }

    @Override
    public void visitResource(String name, ZipInputStream zis) throws IOException {
    }

    @Override
    public void visitPackage(String pkg) {
        this.inits.add(pkg);
    }

    @Override
    public void uploadJar(ByteCodeEnvironment bce, String s) {
    }

    @Override
    public void includePackageFile(ContentObject co) {
        this.js.add(this.copyCOToAppFile("js", co));
    }

    private String copyCOToAppFile(String dir, ContentObject co) {
        Object url = co.url();
        URI uri = URI.create((String)url);
        if (uri.getScheme().equals("file")) {
            File f = new File(uri.getPath());
            File to = new File(this.jsdir, f.getName());
            FileUtils.copyStreamToFile((InputStream)co.asStream(), (File)to);
            url = "/" + dir + "/" + f.getName();
        } else if (uri.getScheme().equals("memory")) {
            File to = new File(this.jsdir, co.key());
            FileUtils.copyStreamToFile((InputStream)co.asStream(), (File)to);
            url = "/" + dir + "/" + co.key();
        } else if (uri.getScheme().equals("https")) {
            File to = new File(this.jsdir, co.key());
            FileUtils.copyStreamToFile((InputStream)co.asStream(), (File)to);
            url = "/" + dir + "/" + co.key();
        } else {
            throw new NotImplementedException("how do I include package file " + (String)url);
        }
        return url;
    }

    @Override
    public void visitCardTemplate(final String cardName, InputStream is, long length) throws IOException {
        final String s = FileUtils.readNStream((long)length, (InputStream)is);
        ContentObject co = new ContentObject(){

            public String key() {
                return null;
            }

            public String url() {
                return null;
            }

            public long length() {
                return 0L;
            }

            public String writeUrl() {
                return null;
            }

            public byte[] asByteArray() {
                return null;
            }

            public InputStream asStream() {
                return null;
            }

            public String asString() {
                return "    <template id='" + cardName + "'>\n" + s + "\n    </template>\n";
            }
        };
        this.temps.add(co);
    }

    @Override
    public void visitCSS(String name, ZipInputStream zis, long length) throws IOException {
        File to = new File(this.cssdir, name);
        FileUtils.copyStreamToFileWithoutClosing((InputStream)zis, (File)to);
        this.css.add(name);
    }

    @Override
    public void leaveAssembly(Assembly a) throws IOException {
        final ApplicationAssembly aa = (ApplicationAssembly)a;
        this.asm.begin();
        this.asm.title(aa.getTitle());
        this.asm.afterTitle();
        for (ContentObject co : this.temps) {
            this.asm.templates(co);
        }
        this.asm.beginCss();
        for (String c : this.css) {
            this.asm.css(this.config.inclPrefix + "/css/" + c);
        }
        this.asm.endCss();
        if (this.config.inclPrefix != null && this.config.inclPrefix.length() > 0) {
            this.asm.beginImportMap();
            for (String j : this.js) {
                this.asm.mapJavascript(j, this.config.inclPrefix + j);
            }
            this.asm.endImportMap();
        }
        this.asm.beginJs();
        FLASCompiler.logger.info("assembly has " + this.js);
        for (String j : this.js) {
            this.asm.javascript(this.config.inclPrefix + j);
        }
        this.asm.endJs();
        this.asm.endHead();
        this.asm.beginInit();
        this.asm.initializer(new CardInitializer(){

            public Iterable<String> packages() {
                return CompilerAssembler.this.inits;
            }

            public String packageName() {
                return aa.name().uniqueName();
            }
        });
        this.asm.endInit();
        this.asm.end();
    }

    @Override
    public void traversalDone() throws Exception {
    }
}

