/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase.names;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.zinutils.exceptions.NotImplementedException;

public class VarName
implements NameOfThing,
Comparable<VarName> {
    public final InputPosition loc;
    public final NameOfThing scope;
    public final String var;

    public VarName(InputPosition loc, NameOfThing name, String var) {
        this.loc = loc;
        this.scope = name;
        this.var = var;
    }

    @Override
    public NameOfThing container() {
        return this.scope;
    }

    @Override
    public PackageName packageName() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.packageName();
    }

    @Override
    public String baseName() {
        return this.var;
    }

    @Override
    public NameOfThing containingCard() {
        return this.scope.containingCard();
    }

    @Override
    public String uniqueName() {
        return this.scope.uniqueName() + "." + this.var;
    }

    @Override
    public String jsName() {
        return this.scope.jsName() + "." + this.var;
    }

    @Override
    public String javaName() {
        throw new NotImplementedException();
    }

    @Override
    public String javaClassName() {
        return this.scope.uniqueName() + "$" + this.var;
    }

    @Override
    public int compareTo(VarName other) {
        int cs = 0;
        if (this.scope != null && other.scope == null) {
            return -1;
        }
        if (this.scope == null && other.scope != null) {
            return 1;
        }
        if (this.scope != null && other.scope != null) {
            cs = this.scope.compareTo(other.scope);
        }
        if (cs != 0) {
            return cs;
        }
        return this.var.compareTo(other.var);
    }

    @Override
    public <T extends NameOfThing> int compareTo(T other) {
        if (!(other instanceof VarName)) {
            return other.getClass().getName().compareTo(this.getClass().getName());
        }
        return this.compareTo((VarName)other);
    }

    @Override
    public String javaPackageName() {
        throw new NotImplementedException();
    }

    public String toString() {
        return "VarName[" + this.uniqueName() + "]";
    }
}

