/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase.names;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.zinutils.exceptions.NotImplementedException;

public class TemplateName
implements NameOfThing,
Comparable<TemplateName> {
    private final InputPosition location;
    private final NameOfThing cardName;
    private final String name;

    public TemplateName(InputPosition location, NameOfThing cardName, String name) {
        this.location = location;
        this.cardName = cardName;
        this.name = name;
    }

    public InputPosition location() {
        return this.location;
    }

    @Override
    public PackageName packageName() {
        return this.cardName.packageName();
    }

    @Override
    public NameOfThing container() {
        return this.cardName;
    }

    @Override
    public String baseName() {
        return this.name;
    }

    @Override
    public String uniqueName() {
        if (this.name == null) {
            return this.cardName.uniqueName();
        }
        return this.cardName.uniqueName() + "." + this.name;
    }

    @Override
    public String jsName() {
        String cn = this.cardName.jsName();
        if (this.name != null) {
            return cn + "." + this.name;
        }
        return cn;
    }

    @Override
    public String javaName() {
        throw new NotImplementedException();
    }

    @Override
    public String javaClassName() {
        throw new NotImplementedException();
    }

    @Override
    public NameOfThing containingCard() {
        return this.cardName;
    }

    @Override
    public int compareTo(TemplateName other) {
        int cs = 0;
        if (this.cardName != null && other.cardName == null) {
            return -1;
        }
        if (this.cardName == null && other.cardName != null) {
            return 1;
        }
        if (this.cardName != null && other.cardName != null) {
            cs = this.cardName.compareTo(other.cardName);
        }
        if (cs != 0) {
            return cs;
        }
        return this.name.compareTo(other.name);
    }

    @Override
    public <T extends NameOfThing> int compareTo(T other) {
        if (!(other instanceof TemplateName)) {
            return other.getClass().getName().compareTo(this.getClass().getName());
        }
        return this.compareTo((TemplateName)other);
    }

    @Override
    public String javaPackageName() {
        throw new NotImplementedException();
    }
}

