/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase.names;

import org.flasck.flas.commonBase.names.NameOfThing;
import org.zinutils.exceptions.InvalidUsageException;

public class PackageName
implements NameOfThing,
Comparable<PackageName> {
    private final PackageName parent;
    private final String name;
    private final Boolean builtin;

    public PackageName(boolean isBuiltin) {
        this.parent = null;
        this.name = null;
        this.builtin = isBuiltin;
    }

    public PackageName(String s) {
        if (s == null) {
            try {
                throw new InvalidUsageException("Must use PackageName(isBuiltin)");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        this.parent = null;
        this.name = s;
        this.builtin = null;
    }

    public PackageName(PackageName parent, String baseName) {
        this.parent = parent;
        this.name = baseName;
        this.builtin = null;
    }

    @Override
    public NameOfThing container() {
        return this.parent;
    }

    @Override
    public PackageName packageName() {
        return this;
    }

    @Override
    public String baseName() {
        return this.name;
    }

    @Override
    public NameOfThing containingCard() {
        return null;
    }

    @Override
    public String uniqueName() {
        if (this.parent != null) {
            return this.parent.uniqueName() + "." + this.name;
        }
        return this.name;
    }

    @Override
    public String jsName() {
        if (this.name == null) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.jsName() + "__" + this.name;
        }
        return this.name.replace(".", "__");
    }

    @Override
    public String javaName() {
        return this.uniqueName();
    }

    @Override
    public String javaPackageName() {
        return this.uniqueName();
    }

    @Override
    public String javaClassName() {
        return this.uniqueName();
    }

    public String simpleName() {
        return this.name;
    }

    public String finalPart() {
        int idx = this.name.lastIndexOf(46);
        if (idx == -1) {
            return this.name;
        }
        return this.name.substring(idx + 1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageName)) {
            return false;
        }
        PackageName pn = (PackageName)obj;
        if (this.name == null && pn.name == null) {
            return true;
        }
        if (this.name == null) {
            return false;
        }
        return obj instanceof PackageName && this.name.equals(pn.name);
    }

    public int hashCode() {
        if (this.name == null) {
            return 0;
        }
        return this.name.hashCode();
    }

    @Override
    public int compareTo(PackageName o) {
        if (this.name == null && o.name == null) {
            return 0;
        }
        if (this.name == null) {
            return -1;
        }
        if (o.name == null) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    @Override
    public <T extends NameOfThing> int compareTo(T other) {
        if (!(other instanceof PackageName)) {
            return other.getClass().getName().compareTo(this.getClass().getName());
        }
        return this.compareTo((PackageName)other);
    }

    public String toString() {
        return "Pkg[" + this.name + "]";
    }

    public boolean isBuiltin() {
        return this.builtin != null && this.builtin != false;
    }
}

