/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase.names;

import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.zinutils.exceptions.NotImplementedException;

public class HandlerName
implements NameOfThing,
Comparable<NameOfThing> {
    public final NameOfThing container;
    public final String baseName;

    public HandlerName(NameOfThing n, String baseName) {
        this.container = n;
        this.baseName = baseName;
    }

    @Override
    public NameOfThing container() {
        return this.container;
    }

    @Override
    public String baseName() {
        return this.baseName;
    }

    @Override
    public NameOfThing containingCard() {
        return this.container.containingCard();
    }

    @Override
    public String uniqueName() {
        if (this.container == null || this.container.uniqueName() == null || this.container.uniqueName().length() == 0) {
            return this.baseName;
        }
        return this.container.uniqueName() + "." + this.baseName;
    }

    @Override
    public String javaName() {
        return this.container.javaName() + "." + this.baseName;
    }

    @Override
    public String javaClassName() {
        return this.container.uniqueName() + "$" + this.baseName;
    }

    @Override
    public int compareTo(NameOfThing o) {
        return this.uniqueName().compareTo(o.uniqueName());
    }

    @Override
    public String jsName() {
        if (this.container == null) {
            return this.baseName;
        }
        return this.container.jsName() + "." + this.baseName;
    }

    @Override
    public String javaPackageName() {
        throw new NotImplementedException();
    }

    @Override
    public PackageName packageName() {
        for (NameOfThing ret = this.container; ret != null; ret = ret.container()) {
            if (!(ret instanceof PackageName)) continue;
            return (PackageName)ret;
        }
        throw new RuntimeException("No PackageName found");
    }

    public String toString() {
        return "Handler[" + this.uniqueName() + "]";
    }
}

