/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase.names;

import java.util.HashMap;
import java.util.Map;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.CSName;
import org.flasck.flas.commonBase.names.CardName;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.commonBase.names.JavaMethodNameProvider;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.ObjectName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.commonBase.names.UnitTestFileName;
import org.flasck.flas.commonBase.names.UnitTestName;
import org.flasck.jvm.J;
import org.zinutils.exceptions.HaventConsideredThisException;

public class FunctionName
implements NameOfThing,
Comparable<NameOfThing>,
JavaMethodNameProvider {
    public final InputPosition location;
    public final String name;
    public final NameOfThing inContext;
    private static final Map<String, String> bimap = new HashMap<String, String>();

    protected FunctionName(InputPosition location, NameOfThing cxt, String name) {
        bimap.put("*", "mul");
        bimap.put("++", "strAppend");
        this.location = location;
        this.name = name;
        this.inContext = cxt;
    }

    @Override
    public String baseName() {
        return this.name;
    }

    public InputPosition location() {
        return this.location;
    }

    public static FunctionName function(InputPosition location, NameOfThing pkg, String name) {
        return new FunctionName(location, pkg, name);
    }

    public static FunctionName caseName(FunctionName inside, int cs) {
        return new FunctionName(inside.location, inside, "_" + cs);
    }

    public static FunctionName eventMethod(InputPosition location, NameOfThing cardName, String name) {
        return new FunctionName(location, cardName, name);
    }

    public static FunctionName contractDecl(InputPosition location, SolidName contractName, String name) {
        return new FunctionName(location, contractName, name);
    }

    public static FunctionName contractMethod(InputPosition location, NameOfThing ctr, String name) {
        return new FunctionName(location, ctr, name);
    }

    public static FunctionName handlerMethod(InputPosition location, HandlerName hn, String name) {
        return new FunctionName(location, hn, name);
    }

    public static FunctionName objectMethod(InputPosition location, NameOfThing on, String name) {
        return new FunctionName(location, on, name);
    }

    public static FunctionName objectCtor(InputPosition location, SolidName on, String name) {
        return new FunctionName(location, on, "_ctor_" + name);
    }

    public static FunctionName standaloneMethod(InputPosition location, NameOfThing pkg, String name) {
        return new FunctionName(location, pkg, name);
    }

    @Override
    public NameOfThing container() {
        return this.inContext;
    }

    @Override
    public PackageName packageName() {
        for (NameOfThing ret = this.inContext; ret != null; ret = ret.container()) {
            if (!(ret instanceof PackageName)) continue;
            return (PackageName)ret;
        }
        return new PackageName(null);
    }

    @Override
    public NameOfThing containingCard() {
        if (this.inContext == null) {
            return null;
        }
        return this.inContext.containingCard();
    }

    @Override
    public String javaName() {
        if (this.inContext == null || this.inContext instanceof PackageName && ((PackageName)this.inContext).baseName() == null) {
            return "org.flasck.jvm.builtin.PACKAGEFUNCTIONS." + this.name;
        }
        if (this.inContext instanceof FunctionName) {
            return this.inContext.javaName() + "_" + this.name;
        }
        return this.inContext.javaName() + "." + this.name;
    }

    @Override
    public String javaClassName() {
        if (this.inContext == null) {
            return J.FLEVAL;
        }
        if (this.inContext instanceof FunctionName) {
            return this.inContext.javaClassName();
        }
        return this.inContext.javaName();
    }

    @Override
    public String javaMethodName() {
        if (this.inContext instanceof FunctionName) {
            return ((FunctionName)this.inContext).javaMethodName() + "_" + this.name;
        }
        return this.name;
    }

    @Override
    public String uniqueName() {
        if (this.inContext == null || this.inContext.uniqueName() == null || this.inContext.uniqueName().length() == 0) {
            return this.name;
        }
        return this.inContext.uniqueName() + "." + this.name;
    }

    @Override
    public String jsName() {
        if (this.inContext == null || this.inContext.jsName() == null || this.inContext.jsName().length() == 0) {
            return this.name;
        }
        if (this.inContext instanceof FunctionName) {
            return ((FunctionName)this.inContext).jsPName() + "." + this.name;
        }
        return this.inContext.jsName() + "." + this.name;
    }

    public String jsPName() {
        if (this.inContext == null || this.inContext.jsName() == null || this.inContext.jsName().length() == 0) {
            return this.name;
        }
        if (this.inContext instanceof FunctionName) {
            return ((FunctionName)this.inContext).jsPName() + "." + this.name;
        }
        if (this.inContext == null || this.inContext instanceof PackageName) {
            return this.inContext.jsName() + "." + this.name;
        }
        return this.inContext.jsName() + ".prototype." + this.name;
    }

    @Override
    public String javaPackageName() {
        return this.inContext.javaName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionName)) {
            return false;
        }
        return this.compareTo((FunctionName)obj) == 0;
    }

    @Override
    public int compareTo(NameOfThing other) {
        return this.uniqueName().compareTo(other.uniqueName());
    }

    public String toString() {
        return "Fn[" + this.uniqueName() + "]";
    }

    public boolean isUnitTest() {
        if (this.inContext instanceof UnitTestName) {
            return true;
        }
        return this.inContext instanceof UnitTestFileName;
    }

    public NameOfThing wrappingObject() {
        if (this.inContext == null || this.inContext instanceof PackageName) {
            return null;
        }
        if (this.inContext instanceof FunctionName) {
            return ((FunctionName)this.inContext).wrappingObject();
        }
        if (this.inContext instanceof CardName || this.inContext instanceof HandlerName || this.inContext instanceof CSName || this.inContext instanceof ObjectName) {
            return this.inContext;
        }
        throw new HaventConsideredThisException("where is this function?");
    }
}

