/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase.names;

import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;

public class CardName
implements NameOfThing,
Comparable<CardName> {
    public final PackageName pkg;
    public final String cardName;

    public CardName(PackageName pkg, String cardName) {
        this.pkg = pkg;
        this.cardName = cardName;
    }

    @Override
    public NameOfThing container() {
        return this.pkg;
    }

    @Override
    public PackageName packageName() {
        return this.pkg;
    }

    @Override
    public String baseName() {
        return this.cardName;
    }

    @Override
    public NameOfThing containingCard() {
        return this;
    }

    @Override
    public String uniqueName() {
        if (this.pkg == null) {
            return this.cardName;
        }
        return this.pkg.uniqueName() + "." + this.cardName;
    }

    @Override
    public String javaPackageName() {
        return this.javaName();
    }

    @Override
    public String javaName() {
        if (this.pkg == null || this.pkg.simpleName() == null) {
            return this.cardName;
        }
        return this.pkg.simpleName() + "." + this.cardName;
    }

    @Override
    public String jsName() {
        if (this.pkg == null || this.pkg.simpleName() == null) {
            return this.cardName;
        }
        return this.pkg.jsName() + "." + this.cardName;
    }

    public String jsUName() {
        if (this.pkg == null || this.pkg.simpleName() == null) {
            return this.cardName;
        }
        return this.pkg.simpleName() + "._" + this.cardName;
    }

    @Override
    public String javaClassName() {
        return this.pkg.uniqueName() + "$" + this.cardName;
    }

    @Override
    public int compareTo(CardName o) {
        int pc = this.pkg.compareTo(o.pkg);
        if (pc != 0) {
            return pc;
        }
        return this.cardName.compareTo(o.cardName);
    }

    @Override
    public <T extends NameOfThing> int compareTo(T other) {
        if (!(other instanceof CardName)) {
            return other.getClass().getName().compareTo(this.getClass().getName());
        }
        return this.compareTo((CardName)other);
    }

    public boolean isValid() {
        return this.pkg != null && this.cardName != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CardName)) {
            return false;
        }
        CardName o = (CardName)obj;
        return this.pkg.equals(o.pkg) && o.cardName.equals(this.cardName);
    }

    public int hashCode() {
        return this.pkg.hashCode() ^ this.cardName.hashCode();
    }

    public String toString() {
        return "Card[" + this.uniqueName() + "]";
    }
}

