/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase.names;

import org.flasck.flas.commonBase.names.CardName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.zinutils.exceptions.NotImplementedException;

public class CSName
implements NameOfThing,
Comparable<CSName> {
    private final CardName card;
    private final String cname;

    public CSName(CardName card, String cname) {
        this.card = card;
        this.cname = cname;
    }

    @Override
    public NameOfThing container() {
        return this.card;
    }

    @Override
    public NameOfThing containingCard() {
        return this.card;
    }

    @Override
    public String baseName() {
        return this.cname;
    }

    @Override
    public String uniqueName() {
        return this.card.uniqueName() + "." + this.cname;
    }

    @Override
    public String jsName() {
        return this.card.jsName() + "." + this.cname;
    }

    @Override
    public String javaName() {
        return this.card.javaName() + "." + this.cname;
    }

    @Override
    public String javaClassName() {
        return this.card.javaName() + "$" + this.cname;
    }

    @Override
    public int compareTo(CSName o) {
        int cc = this.card.compareTo(o.card);
        if (cc != 0) {
            return cc;
        }
        return this.cname.compareTo(o.cname);
    }

    @Override
    public <T extends NameOfThing> int compareTo(T other) {
        if (!(other instanceof CSName)) {
            return other.getClass().getName().compareTo(this.getClass().getName());
        }
        return this.compareTo((CSName)other);
    }

    @Override
    public String javaPackageName() {
        throw new NotImplementedException();
    }

    @Override
    public PackageName packageName() {
        for (NameOfThing ret = this.card; ret != null; ret = ret.container()) {
            if (!(ret instanceof PackageName)) continue;
            return (PackageName)ret;
        }
        throw new RuntimeException("No PackageName found");
    }
}

