/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.commonBase;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;

public class NumericLiteral
implements Expr {
    public final InputPosition location;
    public final String text;
    public final Integer val;

    public NumericLiteral(InputPosition loc, String text, int end) {
        this.location = loc;
        this.location.endAt(end);
        this.text = text;
        this.val = null;
    }

    public NumericLiteral(InputPosition location, int val) {
        this.location = location;
        this.text = null;
        this.val = val;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    public Object value() {
        if (this.val != null) {
            return this.val;
        }
        if (this.text.indexOf(".") != -1 || this.text.indexOf("e") != -1) {
            return Double.parseDouble(this.text);
        }
        return Integer.parseInt(this.text);
    }

    public String toString() {
        if (this.text != null) {
            return this.text;
        }
        return Integer.toString(this.val);
    }
}

