/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.blocker;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.ContinuedLine;
import org.flasck.flas.blockForm.Indent;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.BlockConsumer;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.CommentToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDANester
implements BlockConsumer {
    private final List<TDAParsingWithAction> stack = new ArrayList<TDAParsingWithAction>();
    private InputPosition lastloc;
    private final ErrorReporter errors;
    private final TDAParsing topLevel;

    public TDANester(ErrorReporter errors, TDAParsing topLevel) {
        this.errors = errors;
        this.topLevel = topLevel;
    }

    @Override
    public void newFile() {
        this.lastloc = null;
        this.add(this.topLevel);
    }

    @Override
    public void comment(InputPosition location, String text) {
        this.errors.logParsingToken(new CommentToken(location, text));
    }

    @Override
    public void line(int depth, ContinuedLine currline) {
        if (depth > this.stack.size()) {
            return;
        }
        Tokenizable tkz = new Tokenizable(currline);
        while (this.stack.size() > depth) {
            this.pop();
        }
        this.lastloc = tkz.realinfo();
        TDAParsing nesting = this.stack.get(depth - 1).tryParsing(tkz);
        if (nesting != null) {
            this.add(nesting);
        }
    }

    @Override
    public void flush() {
        if (this.lastloc != null) {
            this.lastloc = new InputPosition(this.lastloc.file, this.lastloc.lineNo + 1, 0, new Indent(0, 0), "");
        }
        while (this.stack.size() > 0) {
            this.pop();
        }
    }

    private void add(TDAParsing parser) {
        if (parser instanceof TDAParsingWithAction) {
            this.stack.add((TDAParsingWithAction)parser);
        } else {
            this.stack.add(new TDAParsingWithAction(parser, null));
        }
    }

    private void pop() {
        TDAParsingWithAction endScope = this.stack.remove(this.stack.size() - 1);
        endScope.scopeComplete(this.lastloc);
        this.afterParsing(endScope);
    }

    private void afterParsing(TDAParsingWithAction endScope) {
        if (endScope.parser instanceof TDAParsingWithAction) {
            this.afterParsing((TDAParsingWithAction)endScope.parser);
        }
        if (endScope.afterParsing != null) {
            endScope.afterParsing.run();
        }
    }
}

