/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.blocker;

import org.flasck.flas.blockForm.ContinuedLine;
import org.flasck.flas.blockForm.Indent;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blockForm.SingleLine;
import org.flasck.flas.blocker.BlockConsumer;
import org.flasck.flas.blocker.BlockerException;
import org.flasck.flas.errors.ErrorReporter;
import org.zinutils.exceptions.UtilException;

public class Blocker {
    private final ErrorReporter errors;
    private final BlockConsumer consumer;
    private ContinuedLine currline;
    private int currLevel = 0;

    public Blocker(ErrorReporter errors, BlockConsumer consumer) {
        this.errors = errors;
        this.consumer = consumer;
    }

    public void newFile() {
        this.consumer.newFile();
    }

    public void present(String file, int lineNumber, String text) {
        try {
            this.consume(file, lineNumber, text);
        }
        catch (BlockerException ex) {
            this.errors.message(new InputPosition(file, lineNumber, this.getIndent((String)text).tabs, null, text), ex.getMessage());
        }
    }

    private void consume(String file, int lineNumber, String text) {
        Indent ind = this.getIndent(text);
        text = text.trim();
        InputPosition pos = new InputPosition(file, lineNumber, 0, ind, text);
        if (ind == null || ind.tabs == 0 && ind.spaces == 0 || text.startsWith("//")) {
            this.consumer.comment(pos, text);
        } else if (ind.tabs == 0 && ind.spaces != 0) {
            this.errors.message(pos, "line cannot start with spaces");
        } else if (ind.tabs == this.currLevel && ind.spaces > 0) {
            this.currline.lines.add(new SingleLine(file, lineNumber, ind, text));
        } else if (ind.tabs <= this.currLevel + 1 && ind.spaces == 0) {
            if (this.currline != null) {
                this.consumer.line(this.currLevel, this.currline);
            }
            this.currline = new ContinuedLine();
            this.currline.lines.add(new SingleLine(file, lineNumber, ind, text));
            this.currLevel = ind.tabs;
        } else if (ind.tabs > this.currLevel + 1) {
            this.errors.message(pos, "invalid indent");
        } else if (ind.tabs == this.currLevel + 1 && ind.spaces > 0) {
            this.errors.message(pos, "illegal continuation line (spaces at front)");
        } else {
            throw new UtilException("We didn't think of that");
        }
    }

    public void flush() {
        if (this.currline != null) {
            this.consumer.line(this.currLevel, this.currline);
            this.currLevel = 0;
            this.currline = null;
        }
        this.consumer.flush();
    }

    private Indent getIndent(String l) {
        int tabs;
        int spaces = 0;
        for (tabs = 0; tabs < l.length() && l.charAt(tabs) == '\t'; ++tabs) {
        }
        while (tabs + spaces < l.length() && l.charAt(tabs + spaces) == ' ') {
            ++spaces;
        }
        if (tabs + spaces < l.length()) {
            return new Indent(tabs, spaces);
        }
        return null;
    }
}

