/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.blockForm;

import org.flasck.flas.blockForm.Indent;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.Justification;

public class InputPosition
implements Comparable<InputPosition> {
    public final String file;
    public final int lineNo;
    public final int off;
    public final Indent indent;
    public final transient String text;
    private int endPos = -1;
    private boolean isFakeToken;

    public InputPosition(String file, int lineNo, int off, Indent ind, String text) {
        this.file = file;
        this.lineNo = lineNo;
        this.off = off;
        this.indent = ind;
        this.text = text;
    }

    public void endAt(int end) {
        if (end == -1) {
            return;
        }
        this.endPos = end;
    }

    public InputPosition copySetEnd(int at) {
        InputPosition ret = new InputPosition(this.file, this.lineNo, this.off, this.indent, this.text);
        ret.endAt(at);
        ret.isFakeToken = this.isFakeToken;
        return ret;
    }

    public String asToken() {
        if (this.endPos < 0) {
            return null;
        }
        return this.text.substring(this.off, this.endPos);
    }

    public boolean hasEnd() {
        return this.endPos >= 0;
    }

    public int pastEnd() {
        if (this.endPos < 0) {
            throw new UtilException("pastEnd called, but not set");
        }
        return this.endPos;
    }

    public String toString() {
        return (this.file != null ? Justification.LEFT.format(this.file + ": ", 12) : "") + Justification.PADLEFT.format(Integer.toString(this.lineNo), 3) + "." + this.off;
    }

    public boolean equals(Object obj) {
        return obj instanceof InputPosition && this.compareTo((InputPosition)obj) == 0;
    }

    @Override
    public int compareTo(InputPosition o) {
        if (o == null) {
            return -1;
        }
        int ret = 0;
        if (this.file != null) {
            ret = this.file.compareTo(o.file);
        }
        if (ret == 0) {
            ret = Integer.compare(this.lineNo, o.lineNo);
        }
        if (ret == 0) {
            ret = Integer.compare(this.off, o.off);
        }
        return ret;
    }

    public InputPosition lesserOf(InputPosition p) {
        if (p == null || this.compareTo(p) <= 0) {
            return this;
        }
        return p;
    }

    public InputPosition fakeToken() {
        this.isFakeToken = true;
        return this;
    }

    public boolean isFake() {
        return this.isFakeToken;
    }

    public String inFile() {
        return Integer.toString(this.lineNo) + ":" + Integer.toString(this.off);
    }

    public InputPosition locAtEnd() {
        return new InputPosition(this.file, this.lineNo, this.endPos, this.indent, this.text);
    }

    public InputPosition plus(int i) {
        return new InputPosition(this.file, this.lineNo, this.off + i, this.indent, this.text);
    }
}

