/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.blockForm;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blockForm.SingleLine;

public class ContinuedLine {
    public final List<SingleLine> lines = new ArrayList<SingleLine>();

    public StringBuilder text() {
        StringBuilder sb = new StringBuilder();
        for (SingleLine l : this.lines) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(l.line.trim());
        }
        return sb;
    }

    public InputPosition locationAtText(int pos) {
        int off = 0;
        for (SingleLine l : this.lines) {
            String trim = l.line.trim();
            if (pos < off + trim.length()) {
                return new InputPosition(l.file, l.lineNo, pos - off, l.indent, trim);
            }
            off += trim.length() + 1;
        }
        SingleLine l = this.lines.get(this.lines.size() - 1);
        return new InputPosition(l.file, l.lineNo, l.line.trim().length(), l.indent, l.line.trim());
    }

    public String toString() {
        return "CL[" + this.text() + "]";
    }

    public int actualLine(int pos) {
        int off = 0;
        for (SingleLine l : this.lines) {
            String trim = l.line.trim();
            if (pos < off + trim.length()) {
                return l.lineNo;
            }
            off += trim.length() + 1;
        }
        return this.lines.size() - 1;
    }
}

