/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.flasck.flas.Configuration;
import org.flasck.flas.LSPMain;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.compiler.FLASCompiler;
import org.flasck.flas.compiler.jsgen.packaging.JSUploader;
import org.flasck.flas.errors.ErrorResult;
import org.flasck.flas.errors.ErrorResultException;
import org.flasck.flas.repository.AssemblyVisitor;
import org.flasck.flas.repository.Repository;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.FileContentObject;
import org.flasck.jvm.ziniki.PackageSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.impl.StaticLoggerBinder;
import org.zinutils.streamedlogger.api.Level;

public class Main {
    public static void main(String[] args) {
        boolean failed;
        Main.setLogLevels();
        if (args != null && args.length >= 1 && "--lsp".equals(args[0])) {
            StaticLoggerBinder.setLevel((String)"Compiler", (Level)Level.INFO);
            LSPMain.run(args);
            return;
        }
        try {
            failed = Main.standardCompiler(null, args);
        }
        catch (ErrorResultException ex) {
            try {
                ((ErrorResult)ex.errors).showTo(new PrintWriter(System.out), 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            failed = true;
        }
        catch (Throwable e) {
            Logger logger = LoggerFactory.getLogger((String)"Compiler");
            logger.error("exception thrown", e);
            failed = true;
        }
        System.exit(failed ? 1 : 0);
    }

    public static boolean standardCompiler(File saveParsingTokens, String ... args) throws IOException, ErrorResultException {
        ErrorResult errors = new ErrorResult(saveParsingTokens);
        Configuration config = new Configuration(errors, args);
        if (!config.preCompilation()) {
            return false;
        }
        FLASCompiler ret = Main.commonCompiler(errors, config);
        errors.closeTokenStream();
        return errors.hasErrors() || ret == null;
    }

    public static boolean uploader(ErrorResult errors, Configuration config, PackageSources cpv, AssemblyVisitor storer) throws IOException {
        Repository repository = new Repository();
        FLASCompiler compiler = new FLASCompiler(config, errors, repository, null);
        compiler.uploader((JSUploader)((Object)storer));
        compiler.loadFLIMFromContentStore();
        compiler.parse(cpv);
        if (errors.hasErrors()) {
            return true;
        }
        for (ContentObject web : cpv.webs()) {
            compiler.splitWeb(web);
        }
        if (errors.hasErrors()) {
            return true;
        }
        compiler.stage2(Arrays.asList(cpv));
        if (errors.hasErrors()) {
            return true;
        }
        compiler.storeAssemblies(storer);
        return errors.hasErrors();
    }

    private static FLASCompiler commonCompiler(ErrorResult errors, Configuration config) throws IOException, FileNotFoundException, ErrorResultException {
        FLASCompiler compiler = Main.doCompilation(errors, config);
        if (errors.hasErrors()) {
            File f = config.writeErrorsTo();
            OutputStreamWriter osw = f != null ? new FileWriter(f) : new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
            errors.showTo(new PrintWriter((Writer)osw, true), 0);
            return null;
        }
        return compiler;
    }

    private static FLASCompiler doCompilation(ErrorResult errors, Configuration config) throws IOException, FileNotFoundException, ErrorResultException {
        if (errors.hasErrors()) {
            return null;
        }
        Repository repository = new Repository();
        FLASCompiler compiler = new FLASCompiler(config, errors, repository, null);
        if (compiler.loadFLIMFromFiles()) {
            return null;
        }
        if (config.inputs.isEmpty()) {
            errors.message((InputPosition)null, "there are no input packages");
            return null;
        }
        for (File web : config.webs) {
            if (!web.canRead()) {
                errors.message((InputPosition)null, "there is no web input: " + web);
                continue;
            }
            if (web.isDirectory()) {
                compiler.splitWeb(web);
                continue;
            }
            compiler.splitWeb((ContentObject)new FileContentObject(web));
        }
        if (errors.hasErrors()) {
            return null;
        }
        ArrayList<PackageSources> packages = new ArrayList<PackageSources>();
        for (File input : config.inputs) {
            packages.add(compiler.processInputFromDirectory(input));
        }
        if (compiler.stage2(packages)) {
            return null;
        }
        return compiler;
    }

    public static void setLogLevels() {
        String defarg;
        Level level = Level.WARN;
        String arg = System.getProperty("org.flas.compiler.tracing");
        if (arg != null) {
            level = Level.valueOf((String)arg.toUpperCase());
        }
        if ((defarg = System.getProperty("streamlogger.defaultLevel")) == null) {
            System.setProperty("streamlogger.defaultLevel", "WARN");
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        StaticLoggerBinder.defaultLevel((String)"Compiler", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Traverser", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Resolver", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Lifter", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Patterns", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"TOPatterns", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"TypeChecker", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"TCUnification", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"HSI", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Generator", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"IdemHandler", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"assembler", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"awstxstore", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"org.ziniki.awstxstore", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"GrammarChecker", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"TestStages", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"CallTracker", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"tdaserver", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"org.glassfish.grizzly", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"org.glassfish.grizzly.nio.GracefulShutdownRunner", (Level)Level.ERROR);
        StaticLoggerBinder.defaultLevel((String)"DI", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ziwshtext", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"TestRunner", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ZiWSH", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"FlasckLib", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ZiwshClient", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Ziniki", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ZinikiZiwsh", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ZinikiTI", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"UOWExec", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"IMUnitOfWork", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Broker", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Utils", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"BrokerDelegate", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"BTResponder", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ClientContext", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ZinDelivery", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Dispatcher", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Send", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"GLS", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"TxManagerThreading", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Security", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"Uploader", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"ErrorResult", (Level)level);
        StaticLoggerBinder.defaultLevel((String)"DebugLog", (Level)Level.INFO);
    }
}

