/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.flasck.flas.compiler.CompileUnit;
import org.flasck.flas.compiler.FLASCompiler;
import org.flasck.flas.compiler.TaskQueue;
import org.flasck.flas.lsp.CompileTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSPTaskQueue
implements TaskQueue {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    private final Executor exec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.tasks);
    private final Set<CompileUnit> units = new HashSet<CompileUnit>();

    @Override
    public void loadFLIM(final URI uri, final FLASCompiler compiler) {
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                compiler.lspLoadFLIM(uri);
            }
        });
    }

    @Override
    public void submit(CompileTask ct) {
        if (ct != null && !this.tasks.contains(ct)) {
            this.exec.execute(ct);
        }
    }

    @Override
    public synchronized void readyWhenYouAre(final URI uri, CompileUnit stage2) {
        this.units.add(stage2);
        if (this.tasks.isEmpty()) {
            logger.info("Adding stage2 to workflow for " + uri);
            final HashSet<CompileUnit> ready = new HashSet<CompileUnit>(this.units);
            this.units.clear();
            this.exec.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("Attempting rest for " + ready);
                    for (CompileUnit unit : ready) {
                        unit.attemptRest(uri);
                    }
                }
            });
        }
    }
}

