/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.compiler.PhaseTo;
import org.flasck.flas.compiler.modules.OptionModule;
import org.flasck.flas.compiler.modules.PreCompilationModule;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.jvm.ziniki.PackageSources;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.tdastore.support.InternalContentStorage;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.FileUtils;

public class Configuration {
    private final ServiceLoader<OptionModule> optionModules;
    private final ServiceLoader<PreCompilationModule> precompilationModules;
    public final ErrorReporter errors;
    public boolean unitjvm = true;
    public boolean unitjs = false;
    public boolean systemjvm = true;
    public boolean systemjs = false;
    public boolean usesplitter = true;
    public File projectDir;
    public File writeFlim = null;
    public boolean doTypeCheck = true;
    public boolean generateJS = true;
    public boolean generateJVM = true;
    public boolean genapps = true;
    public String html;
    public String inclPrefix = "/";
    PhaseTo upto = PhaseTo.COMPLETE;
    File dumprepo = null;
    public final List<File> inputs = new ArrayList<File>();
    public final List<File> webs = new ArrayList<File>();
    private File writeTestReportsTo;
    private File writeErrorsTo;
    public File writeTypesTo;
    public String jstestdir;
    public String specifiedTestName;
    public String flascklibDir;
    public File moduleDir;
    public PackageSources flascklibCPV;
    public List<PackageSources> moduleCOs;
    public List<PackageSources> dependencies;
    public final List<File> includeFrom = new ArrayList<File>();
    public final List<File> loadJars = new ArrayList<File>();
    public final List<String> modules = new ArrayList<String>();
    public ContentStorage contentStore = new InternalContentStorage();

    public Configuration(ErrorReporter errors, String[] args) {
        this.optionModules = ServiceLoader.load(OptionModule.class);
        this.precompilationModules = ServiceLoader.load(PreCompilationModule.class);
        this.errors = errors;
        if (args != null) {
            this.process(args);
        }
    }

    private void process(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("--project-dir")) continue;
            if (this.projectDir != null) {
                System.out.println("--project-dir can only be specified once");
                System.exit(1);
                continue;
            }
            if (i == args.length - 1) {
                System.out.println("--project-dir <dir>");
                System.exit(1);
                continue;
            }
            this.projectDir = new File(args[++i]);
        }
        boolean error = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null || arg.length() == 0) continue;
            int hasMore = args.length - i - 1;
            if (arg.startsWith("-")) {
                if (arg.equals("--project-dir")) {
                    ++i;
                    continue;
                }
                if (arg.equals("--module")) {
                    this.modules.add(args[++i]);
                    continue;
                }
                if (arg.equals("--html")) {
                    if (this.html != null) {
                        System.out.println("--html can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--html <file>");
                        System.exit(1);
                    }
                    this.html = args[++i];
                    continue;
                }
                if (arg.equals("--incl-prefix")) {
                    if (!this.inclPrefix.equals("/")) {
                        System.out.println("--incl-prefix can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--incl-prefix <prefix>");
                        System.exit(1);
                    }
                    this.inclPrefix = args[++i];
                    continue;
                }
                if (arg.equals("--testname")) {
                    if (this.specifiedTestName != null) {
                        System.out.println("--testname can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--testname <name>");
                        System.exit(1);
                    }
                    this.specifiedTestName = args[++i];
                    continue;
                }
                if (arg.equals("--flim")) {
                    if (this.writeFlim != null) {
                        System.out.println("--flim can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--flim <dir>");
                        System.exit(1);
                    }
                    this.writeFlim = new File(args[++i]);
                    continue;
                }
                if (arg.equals("--import")) {
                    if (hasMore == 0) {
                        System.out.println("--import <dir>");
                        System.exit(1);
                    }
                    this.includeFrom.add(new File(args[++i]));
                    continue;
                }
                if (arg.equals("--phase")) {
                    if (this.upto != PhaseTo.COMPLETE) {
                        System.out.println("--phase can only be specified once");
                        error = true;
                    }
                    this.upto = PhaseTo.valueOf(args[++i]);
                    continue;
                }
                if (arg.equals("--unit-js")) {
                    this.unitjs = true;
                    continue;
                }
                if (arg.equals("--no-unit-jvm")) {
                    this.unitjvm = false;
                    continue;
                }
                if (arg.equals("--system-js")) {
                    this.systemjs = true;
                    continue;
                }
                if (arg.equals("--no-system-jvm")) {
                    this.systemjvm = false;
                    continue;
                }
                if (arg.equals("--no-gen-apps")) {
                    this.genapps = false;
                    continue;
                }
                if (arg.equals("--flascklib")) {
                    if (this.flascklibDir != null) {
                        System.out.println("--flascklib can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--flascklib <dir>");
                        System.exit(1);
                    }
                    this.flascklibDir = args[++i];
                    continue;
                }
                if (arg.equals("--store-html")) {
                    if (this.jstestdir != null) {
                        System.out.println("--store-html can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--store-html <dir>");
                        System.exit(1);
                    }
                    this.jstestdir = args[++i];
                    continue;
                }
                if (arg.equals("--moduledir")) {
                    if (this.moduleDir != null) {
                        System.out.println("--moduledir can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--moduledir <dir>");
                        System.exit(1);
                    }
                    this.moduleDir = new File(args[++i]);
                    continue;
                }
                if (arg.equals("--web")) {
                    if (hasMore == 0) {
                        System.out.println("--web <dir|zip>");
                        System.exit(1);
                    }
                    this.webs.add(new File(this.projectDir, args[++i]));
                    continue;
                }
                if (arg.equals("--capture-repository")) {
                    if (this.specifiedTestName != null) {
                        System.out.println("--capture-repository can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--capture-repository <dir>");
                        System.exit(1);
                    }
                    this.dumprepo = new File(this.projectDir, args[++i]);
                    continue;
                }
                if (arg.equals("--errors")) {
                    if (this.writeErrorsTo != null) {
                        System.out.println("--errors can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--errors <dir>");
                        System.exit(1);
                    }
                    this.writeErrorsTo = new File(this.projectDir, args[++i]);
                    continue;
                }
                if (arg.equals("--types")) {
                    if (this.writeTypesTo != null) {
                        System.out.println("--types can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--types <dir>");
                        System.exit(1);
                    }
                    this.writeTypesTo = new File(this.projectDir, args[++i]);
                    continue;
                }
                if (arg.equals("--testReports")) {
                    if (this.writeTestReportsTo != null) {
                        System.out.println("--testReports can only be specified once");
                        error = true;
                    }
                    if (hasMore == 0) {
                        System.out.println("--testReports <dir>");
                        System.exit(1);
                    }
                    this.writeTestReportsTo = new File(this.projectDir, args[++i]);
                    continue;
                }
                boolean matched = false;
                for (OptionModule om : this.optionModules) {
                    int cnt = om.options(this.errors, args, i);
                    if (cnt <= 0) continue;
                    i += cnt - 1;
                    matched = true;
                    break;
                }
                if (matched) continue;
                this.errors.message((InputPosition)null, "unknown option: " + arg);
                continue;
            }
            this.inputs.add(new File(this.projectDir, arg));
        }
        if (error) {
            System.exit(1);
        }
        if (this.moduleDir == null && !this.modules.isEmpty()) {
            this.errors.message((InputPosition)null, "cannot specify --module without --moduledir");
        }
        if (this.html != null && this.flascklibDir == null) {
            this.errors.message((InputPosition)null, "Use of --html requires --flascklib");
        }
    }

    public boolean preCompilation() {
        try {
            boolean ret = true;
            for (PreCompilationModule m : this.precompilationModules) {
                ret &= m.preCompilation(this);
            }
            return ret;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public String jsTestDir() {
        File front = this.projectDir != null ? (this.projectDir.isAbsolute() ? this.projectDir : FileUtils.combine((Object[])new Object[]{System.getProperty("user.dir"), this.projectDir})) : new File(System.getProperty("user.dir"));
        if (this.jstestdir != null) {
            if (new File(this.jstestdir).isAbsolute()) {
                return this.jstestdir;
            }
            return new File(front, this.jstestdir).getPath();
        }
        return front.getPath();
    }

    public File writeErrorsTo() {
        return this.writeErrorsTo;
    }

    public File writeTestReportsTo() {
        if (this.writeTestReportsTo != null) {
            return this.writeTestReportsTo;
        }
        return null;
    }

    public File flimdir() {
        return this.writeFlim;
    }

    public File dumprepo() {
        return this.dumprepo;
    }

    public PhaseTo upto() {
        return this.upto;
    }

    public <T extends OptionModule> T getOptionsModule(Class<T> clz) {
        for (OptionModule o : this.optionModules) {
            if (!clz.isInstance(o)) continue;
            return (T)((OptionModule)clz.cast(o));
        }
        return null;
    }
}

