/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.tdastore.support;

import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.ziniki.ziwsh.intf.Param;

public class UOWExecutorJVM
implements UOWExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)"UOWExec");
    private final Executor underlying;
    private final Executor blocking;

    public UOWExecutorJVM(@Param(value="executor") Executor underlying, @Param(value="blocking") Executor blocking) {
        this.underlying = underlying;
        this.blocking = blocking;
    }

    @Override
    public Executor getMain() {
        return this.underlying;
    }

    @Override
    public void execute(ThreadAwareUOW uow, boolean willBlock, Runnable runnable) {
        String which = willBlock ? "blocking" : "underlying";
        Runnable command = () -> {
            try {
                logger.info("running command " + runnable + " in " + which);
                uow.getManager().currentThreadUOW(uow);
                runnable.run();
            }
            catch (Throwable t) {
                logger.error("Error processing command in UOW", t);
                uow.fatalError(t);
            }
            finally {
                logger.info("command " + runnable + " in " + which + " completed");
                uow.getManager().currentThreadUOW(null);
            }
        };
        logger.info("adding command to " + which);
        if (willBlock) {
            this.blocking.execute(command);
        } else {
            this.underlying.execute(command);
        }
    }
}

