/*
 * Decompiled with CFR 0.152.
 */
package test.support.intf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.junit.Assert;
import org.zinutils.reflection.Reflection;

public class ZinikiHandlerDouble {
    private Map<String, CaptureAction> actions = new HashMap<String, CaptureAction>();

    public ZinikiHandlerDouble(Mockery context) {
    }

    public Action capture(String id) {
        CaptureAction ret = new CaptureAction();
        Assert.assertFalse((String)("cannot specify the action " + id + " multiple times"), (boolean)this.actions.containsKey(id));
        this.actions.put(id, ret);
        return ret;
    }

    public void dispatch(String id, Object ... args) {
        CaptureAction a = this.actions.get(id);
        Assert.assertNotNull((String)("No action " + id + " has been captured"), (Object)a);
        a.dispatch(id, args);
    }

    public void dispatchMethod(String id, String method, Object ... args) {
        CaptureAction a = this.actions.get(id);
        Assert.assertNotNull((String)("No action " + id + " has been captured"), (Object)a);
        a.dispatchMethod(id, method, args);
    }

    public void dispatchArgMethod(String id, int arg, String method, Object ... args) {
        CaptureAction a = this.actions.get(id);
        Assert.assertNotNull((String)("No action " + id + " has been captured"), (Object)a);
        a.dispatchArgMethod(id, arg, method, args);
    }

    public Object getArg(String id, int i) {
        CaptureAction a = this.actions.get(id);
        Assert.assertNotNull((Object)("No action " + id + " has been captured"));
        return a.getArgument(i);
    }

    public Action respondWith(Object ... args) {
        return new RespondAction("handle", args);
    }

    public Action respondToMethod(String method, Object ... args) {
        return new RespondAction(method, args);
    }

    public Matcher<Object> argMatcher(final String id, final int arg) {
        return new TypeSafeMatcher<Object>(){

            public void describeTo(Description arg0) {
                if (this.hasIt()) {
                    arg0.appendText("previously delivered ");
                } else {
                    arg0.appendText("not yet delivered ");
                }
                arg0.appendValue((Object)id);
                arg0.appendText(":");
                arg0.appendValue((Object)arg);
                if (this.hasIt()) {
                    arg0.appendText(": ");
                    arg0.appendValue(ZinikiHandlerDouble.this.getArg(id, arg));
                }
            }

            protected boolean matchesSafely(Object arg0) {
                if (!this.hasIt()) {
                    return false;
                }
                return ZinikiHandlerDouble.this.getArg(id, arg).equals(arg0);
            }

            private boolean hasIt() {
                if (!ZinikiHandlerDouble.this.actions.containsKey(id)) {
                    return false;
                }
                CaptureAction a = ZinikiHandlerDouble.this.actions.get(id);
                return !a.invocations.isEmpty();
            }
        };
    }

    public class CaptureAction
    implements Action {
        private List<Invocation> invocations = new ArrayList<Invocation>();

        public void describeTo(Description arg0) {
            arg0.appendText("A capture action ... so what?");
        }

        public Object invoke(Invocation arg0) throws Throwable {
            this.invocations.add(arg0);
            return null;
        }

        public void dispatch(String id, Object[] args) {
            Assert.assertFalse((String)("There were no remaining actions associated with " + id), (boolean)this.invocations.isEmpty());
            Invocation inv = this.invocations.remove(0);
            Object handler = inv.getParameter(inv.getParameterCount() - 1);
            Reflection.call((Object)handler, (String)"handle", (Object[])args);
            if (this.invocations.isEmpty()) {
                ZinikiHandlerDouble.this.actions.remove(id);
            }
        }

        public void dispatchMethod(String id, String method, Object[] args) {
            Assert.assertFalse((String)("There were no remaining actions associated with " + id), (boolean)this.invocations.isEmpty());
            Invocation inv = this.invocations.remove(0);
            Object handler = inv.getParameter(inv.getParameterCount() - 1);
            Reflection.call((Object)handler, (String)method, (Object[])args);
            if (this.invocations.isEmpty()) {
                ZinikiHandlerDouble.this.actions.remove(id);
            }
        }

        public void dispatchArgMethod(String id, int arg, String method, Object[] args) {
            Assert.assertFalse((String)("There were no remaining actions associated with " + id), (boolean)this.invocations.isEmpty());
            Object handler = this.getArgument(arg);
            Reflection.call((Object)handler, (String)method, (Object[])args);
        }

        public Object getArgument(int i) {
            Invocation inv = this.invocations.get(0);
            Assert.assertTrue((i >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((i < inv.getParameterCount() ? 1 : 0) != 0);
            return inv.getParameter(i);
        }
    }

    public class RespondAction
    implements Action {
        private final String method;
        private final Object[] args;

        public RespondAction(String method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        public void describeTo(Description arg0) {
            arg0.appendText("will respond by calling ");
            arg0.appendValue((Object)this.method);
            arg0.appendText("with arguments");
            for (Object o : this.args) {
                arg0.appendText(" ");
                arg0.appendValue(o);
            }
        }

        public Object invoke(Invocation inv) throws Throwable {
            Object handler = inv.getParameter(inv.getParameterCount() - 1);
            Reflection.call((Object)handler, (String)this.method, (Object[])this.args);
            return null;
        }
    }
}

