/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.deployment.fl;

import java.io.File;
import java.util.List;
import org.flasck.jvm.assembly.CardInitializer;
import org.flasck.jvm.assembly.PackageInfo;
import org.flasck.jvm.assembly.VisitingPackageInfo;
import org.flasck.jvm.assembly.WaitAMo;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.deployment.fl.AsyncApplicationAssemblyTraverser;
import org.ziniki.deployment.fl.JVMPackageInfo;
import org.zinutils.exceptions.NotImplementedException;

public class AsyncPackageInfoTraverser {
    private final String appname;
    private final VisitingPackageInfo v;
    private final JVMPackageInfo asm;
    private AsyncApplicationAssemblyTraverser.Mode mode;
    private int next = 0;

    public AsyncPackageInfoTraverser(String appname, PackageInfo c, VisitingPackageInfo v) {
        this.appname = appname;
        this.asm = (JVMPackageInfo)c;
        this.v = v;
    }

    public WaitAMo nextStep() {
        WaitAMo ret;
        switch (this.mode) {
            case TITLE: {
                ret = this.v.title((String)this.asm.get("title"));
                this.mode = AsyncApplicationAssemblyTraverser.Mode.CSS;
                break;
            }
            case CSS: {
                List cssfiles = (List)this.asm.get("css");
                if (cssfiles == null || this.next >= cssfiles.size()) {
                    return WaitAMo.DONE;
                }
                ret = this.v.css("/app/" + this.appname + "/" + ((ContentObject)cssfiles.get(this.next++)).key());
                break;
            }
            case IMPORTMAP: {
                List jsfiles = (List)this.asm.get("javascript");
                if (jsfiles == null || this.next >= jsfiles.size()) {
                    return WaitAMo.DONE;
                }
                ContentObject co = (ContentObject)jsfiles.get(this.next++);
                File f = new File(co.key());
                ret = this.v.mapJavascript("/js/" + f.getName(), "/app/" + this.appname + "/" + co.key());
                break;
            }
            case JS: {
                List jsfiles = (List)this.asm.get("javascript");
                if (jsfiles == null || this.next >= jsfiles.size()) {
                    return WaitAMo.DONE;
                }
                ret = this.v.javascript("/app/" + this.appname + "/" + ((ContentObject)jsfiles.get(this.next++)).key());
                break;
            }
            case INIT: {
                List inits = (List)this.asm.get("inits");
                if (inits == null || this.next >= inits.size()) {
                    return WaitAMo.DONE;
                }
                ret = this.v.initializer((CardInitializer)inits.get(this.next++));
                break;
            }
            case DONE: {
                this.v.done();
                return WaitAMo.DONE;
            }
            default: {
                throw new NotImplementedException("Cannot handle mode " + this.mode);
            }
        }
        return ret;
    }

    public void mode(AsyncApplicationAssemblyTraverser.Mode m) {
        this.mode = m;
        this.next = 0;
    }
}

