/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.deployment.fl;

import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.assembly.Activatable;
import org.flasck.jvm.assembly.PackageInfo;
import org.flasck.jvm.assembly.VisitingPackageInfo;
import org.flasck.jvm.assembly.WaitAMo;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.deployment.fl.AsyncPackageInfoTraverser;
import org.ziniki.deployment.fl.JVMApplicationAssembly;
import org.zinutils.exceptions.NotImplementedException;

public class AsyncApplicationAssemblyTraverser
implements Activatable {
    private final VisitingPackageInfo v;
    private final JVMApplicationAssembly asm;
    private final List<AsyncPackageInfoTraverser> traversers;
    private Mode mode = Mode.BEGIN;
    private int eb = -1;
    private int next = 0;

    public AsyncApplicationAssemblyTraverser(String appname, JVMApplicationAssembly asm, VisitingPackageInfo v) {
        List pkgs = (List)asm.get("packages");
        this.traversers = new ArrayList<AsyncPackageInfoTraverser>();
        if (pkgs != null) {
            for (PackageInfo c : pkgs) {
                this.traversers.add(new AsyncPackageInfoTraverser(appname, c, v));
            }
        }
        this.asm = asm;
        this.v = v;
    }

    public WaitAMo activate() {
        WaitAMo ret;
        while ((ret = this.nextStep()).pleaseContinue()) {
        }
        return ret;
    }

    private WaitAMo nextStep() {
        WaitAMo ret;
        if (this.eb != -1 && !(ret = this.doEndBegin()).pleaseContinue()) {
            return ret;
        }
        switch (this.mode) {
            case BEGIN: {
                return this.moveOn(Mode.TITLE);
            }
            case TITLE: {
                ret = this.v.title((String)this.asm.get("title"));
                this.eb = 0;
                if (!ret.pleaseContinue()) {
                    return ret;
                }
                return this.moveOn(Mode.CSS);
            }
            case CSS: {
                return this.doAll(Mode.IMPORTMAP);
            }
            case IMPORTMAP: {
                return this.doAll(Mode.JS);
            }
            case JS: {
                return this.doAll(Mode.INIT);
            }
            case INIT: {
                return this.doAll(Mode.END);
            }
            case END: {
                return this.moveOn(Mode.DONE);
            }
            case DONE: {
                this.v.done();
                return WaitAMo.DONE;
            }
        }
        throw new NotImplementedException("Cannot handle mode " + this.mode);
    }

    private void reset() {
        this.next = 0;
        for (AsyncPackageInfoTraverser t : this.traversers) {
            t.mode(this.mode);
        }
    }

    private WaitAMo doAll(Mode nextMode) {
        while (this.next < this.traversers.size()) {
            WaitAMo ret;
            AsyncPackageInfoTraverser t = this.traversers.get(this.next);
            while ((ret = t.nextStep()) != WaitAMo.DONE) {
            }
            if (ret != WaitAMo.DONE) {
                return ret;
            }
            ++this.next;
        }
        return this.moveOn(nextMode);
    }

    private WaitAMo moveOn(Mode nextMode) {
        WaitAMo ret = this.doEndBegin();
        if (!ret.pleaseContinue()) {
            return ret;
        }
        this.mode = nextMode;
        this.reset();
        return WaitAMo.CONTINUE;
    }

    private WaitAMo doEndBegin() {
        if (this.eb == -1) {
            this.eb = 0;
        }
        switch (this.mode) {
            case BEGIN: {
                WaitAMo ret = this.v.begin();
                if (ret.pleaseContinue()) {
                    this.eb = -1;
                }
                return ret;
            }
            case TITLE: {
                WaitAMo ret;
                if (this.eb == 0) {
                    ret = this.v.afterTitle();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = 1;
                }
                if (this.eb == 1) {
                    WaitAMo ret2;
                    ContentObject tco = (ContentObject)this.asm.get("templates");
                    if (tco != null && !(ret2 = this.v.templates(tco)).pleaseContinue()) {
                        return ret2;
                    }
                    this.eb = 2;
                }
                if (this.eb == 2) {
                    ret = this.v.beginCss();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = -1;
                }
                return WaitAMo.CONTINUE;
            }
            case CSS: {
                WaitAMo ret;
                if (this.eb == 0) {
                    ret = this.v.endCss();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = 1;
                }
                if (this.eb == 1) {
                    ret = this.v.beginImportMap();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = -1;
                }
                return WaitAMo.CONTINUE;
            }
            case IMPORTMAP: {
                WaitAMo ret;
                if (this.eb == 0) {
                    ret = this.v.endImportMap();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = 1;
                }
                if (this.eb == 1) {
                    ret = this.v.beginJs();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = -1;
                }
                return WaitAMo.CONTINUE;
            }
            case JS: {
                WaitAMo ret;
                if (this.eb == 0) {
                    ret = this.v.endJs();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = 1;
                }
                if (this.eb == 1) {
                    ret = this.v.beginInit();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = -1;
                }
                return WaitAMo.CONTINUE;
            }
            case INIT: {
                if (this.eb == 0) {
                    WaitAMo ret = this.v.endInit();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = -1;
                }
                return WaitAMo.CONTINUE;
            }
            case END: {
                if (this.eb == 0) {
                    WaitAMo ret = this.v.end();
                    if (!ret.pleaseContinue()) {
                        return ret;
                    }
                    this.eb = -1;
                }
                return WaitAMo.CONTINUE;
            }
        }
        throw new NotImplementedException();
    }

    static enum Mode {
        BEGIN,
        TITLE,
        CSS,
        IMPORTMAP,
        JS,
        INIT,
        END,
        DONE;

    }
}

