/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.common.ZiIdURI;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.range.SequenceNo;
import org.ziniki.tdastore.ZiidRangeProvider;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.sync.MR1WMap;

public class ZiIdURLFactory
implements ZiIdFactory,
Supplier<MR1WMap<SequenceNo>> {
    public static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final ZiidRangeProvider provider;
    private final int port = -1;
    private final MR1WMap<MR1WMap<SequenceNo>> sequences = new MR1WMap((Supplier)this);
    private final Supplier<SequenceNo> newSequenceNo = new Supplier<SequenceNo>(){

        @Override
        public SequenceNo get() {
            return new SequenceNo(ZiIdURLFactory.this.provider);
        }
    };

    public ZiIdURLFactory(@Param(value="ziidRangeProvider") ZiidRangeProvider provider) {
        this.provider = provider;
    }

    public ZiId unique(String scheme, String host, String type) {
        String userinfo = null;
        String query = null;
        String version = "1";
        String path = "/" + type;
        try {
            URI uri = new URI(scheme, userinfo, host, -1, path, query, version);
            return new ZiIdURI(uri);
        }
        catch (URISyntaxException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public ZiId simple(String scheme, String host, String type, String unique) {
        String userinfo = null;
        String query = null;
        String version = "1";
        String path = "/" + type + "/" + unique;
        try {
            URI uri = new URI(scheme, userinfo, host, -1, path, query, version);
            return new ZiIdURI(uri);
        }
        catch (URISyntaxException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void taken(String name) {
        String qual;
        URI uri = URI.create(name);
        String path = uri.getPath();
        int idx = path.indexOf(qual = "/memory");
        if (idx != -1) {
            String scheme = uri.getScheme();
            String type = path.substring(1, idx);
            int cnt = Integer.parseInt(path.substring(idx + qual.length()), 16);
            SequenceNo sqno = this.getSeqNo(scheme, type);
            sqno.atleast(scheme, type, cnt);
        }
    }

    public ZiId nextInSequence(String scheme, String host, String type) {
        SequenceNo sqno = this.getSeqNo(scheme, type);
        return this.simple(scheme, host, type, sqno.next(scheme, type));
    }

    private SequenceNo getSeqNo(String scheme, String type) {
        SequenceNo sqno;
        MR1WMap scmap = (MR1WMap)this.sequences.get(scheme);
        if (scmap == null) {
            scmap = (MR1WMap)this.sequences.create(scheme);
        }
        if ((sqno = (SequenceNo)scmap.get(type)) == null) {
            sqno = (SequenceNo)scmap.create(type);
        }
        return sqno;
    }

    @Override
    public MR1WMap<SequenceNo> get() {
        return new MR1WMap(this.newSequenceNo);
    }
}

