/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.common;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.intf.ZiId;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.zinutils.exceptions.WrappedException;

public class ZiIdURI
implements ZiId,
Wireable {
    public static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final URI uri;

    ZiIdURI(URI uri) {
        this.uri = uri;
    }

    public Map<String, Object> fields() throws IOException {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        ret.put("uri", this.toString());
        return ret;
    }

    public static ZiIdURI fromString(String id) {
        logger.debug("creating id from " + id);
        return new ZiIdURI(URI.create(id));
    }

    public static ZiIdURI fromWire(EvalContext cx, ObjectMarshalling om, Map<String, Object> args) {
        return new ZiIdURI(URI.create((String)args.get("uri")));
    }

    public String unique() {
        return this.uri.getPath();
    }

    public String lastSegment() {
        String path = this.uri.getPath();
        int idx = path.lastIndexOf(47);
        if (idx == -1) {
            return path;
        }
        return path.substring(idx + 1);
    }

    public ZiIdURI makeType(String type) {
        try {
            int idx;
            String path = this.uri.getPath();
            String newpath = "/" + type;
            if (path != null && path.length() > 2 && (idx = path.indexOf(47, 1)) != -1) {
                newpath = newpath + path.substring(idx);
            }
            return new ZiIdURI(new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), newpath, this.uri.getQuery(), null));
        }
        catch (URISyntaxException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public ZiIdURI removeLast() {
        try {
            String path = this.uri.getPath();
            int idx = path.lastIndexOf(47);
            path = idx == -1 ? "" : path.substring(0, idx);
            return new ZiIdURI(new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), path, this.uri.getQuery(), null));
        }
        catch (URISyntaxException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public ZiIdURI append(String segment) {
        try {
            String newpath = this.uri.getPath() + "/" + URLEncoder.encode(segment, "UTF-8");
            return new ZiIdURI(new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), newpath, this.uri.getQuery(), null));
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public String toString() {
        try {
            return new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.uri.getQuery(), null).toString();
        }
        catch (URISyntaxException e) {
            return this.uri.toString();
        }
    }

    public URI uri() {
        return this.uri;
    }

    public ZiIdURI makeScheme(String scheme) {
        try {
            return new ZiIdURI(new URI(scheme, this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.uri.getQuery(), null));
        }
        catch (URISyntaxException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public static String changeScheme(String from, String scheme) {
        try {
            URI uri = URI.create(from);
            return new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toString();
        }
        catch (URISyntaxException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public boolean schemeIs(String scheme) {
        return this.uri.getScheme().equals(scheme);
    }
}

