/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.streamedlogger.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.zinutils.streamedlogger.StreamedLoggerConfig;
import org.zinutils.streamedlogger.impl.FileConsumer;

public class FileStreamedLoggerConfig
extends StreamedLoggerConfig {
    private File root;
    private Map<String, FileConsumer> open = new ConcurrentHashMap<String, FileConsumer>();
    private FileConsumer defaultFile;
    static FileFilter isdirectory = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.isDirectory();
        }
    };

    public FileStreamedLoggerConfig(Properties config, Callable<String> streamIdentifier) throws IOException {
        super(config, streamIdentifier);
        File tmp;
        String root = config.getProperty("streamlogger.root");
        if (root == null) {
            tmp = new File(".");
        } else {
            tmp = new File(root);
            this.assertCleanDirectory(tmp);
        }
        this.root = tmp.getCanonicalFile();
        this.defaultFile = new FileConsumer(new File(this.root, "default.log"));
    }

    @Override
    public Consumer<String> streamSink(String stream) {
        FileConsumer ret;
        if (!this.wantStreams || stream == null || stream.equals("default.log")) {
            return this.defaultFile;
        }
        if (this.open.containsKey(stream)) {
            return this.open.get(stream);
        }
        try {
            ret = new FileConsumer(new File(this.root, stream));
        }
        catch (Exception ex) {
            ret = this.defaultFile;
        }
        this.open.put(stream, ret);
        return ret;
    }

    private void assertCleanDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Cannot create directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("File '" + dir + "' is not a directory");
        }
        FileFilter anyFile = new FileFilter(){

            @Override
            public boolean accept(File dir) {
                return true;
            }
        };
        Comparator<File> pathLengthComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.getPath().length() > o2.getPath().length()) {
                    return -1;
                }
                if (o1.getPath().length() == o2.getPath().length()) {
                    return 0;
                }
                return 1;
            }
        };
        ArrayList<File> ret = new ArrayList<File>();
        FileStreamedLoggerConfig.findRecursive(ret, anyFile, dir, dir, true);
        Collections.sort(ret, pathLengthComparator);
        for (File f : ret) {
            if (f.delete()) continue;
            throw new RuntimeException("Could not delete: " + f);
        }
    }

    private static void findRecursive(List<File> ret, FileFilter filter, File under, File dir, boolean recurse) {
        File[] contents = dir.listFiles(filter);
        if (contents == null) {
            return;
        }
        for (File f : contents) {
            ret.add(f);
        }
        if (recurse) {
            File[] subdirs;
            for (File d : subdirs = dir.listFiles(isdirectory)) {
                FileStreamedLoggerConfig.findRecursive(ret, filter, under, d, recurse);
            }
        }
    }
}

