/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.streamedlogger;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.StaticLoggerBinder;
import org.zinutils.streamedlogger.StreamedLogger;
import org.zinutils.streamedlogger.StreamedLoggerConfig;
import org.zinutils.streamedlogger.api.Level;
import org.zinutils.streamedlogger.impl.ConsoleStreamedLoggerConfig;

public class StreamedLoggerFactory
implements ILoggerFactory {
    public static StaticLoggerBinder binder;
    private final StreamedLoggerConfig config;
    private final Map<String, StreamedLogger> loggers = new TreeMap<String, StreamedLogger>();

    public StreamedLoggerFactory(Properties props, Callable<String> streamIdentifier) {
        if (binder != null) {
            throw new RuntimeException("Cannot call StreamedLoggerFactory constructor twice");
        }
        String config = (String)props.get("streamlogger.config");
        try {
            if (config == null) {
                this.config = new ConsoleStreamedLoggerConfig(props, streamIdentifier);
            } else {
                Class<?> clz = Class.forName(config);
                Constructor<?> ctor = clz.getConstructor(Properties.class, Callable.class);
                this.config = (StreamedLoggerConfig)ctor.newInstance(props, streamIdentifier);
            }
            binder = new StaticLoggerBinder(this);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not configure logger", ex);
        }
    }

    public static boolean isInit() {
        return binder != null;
    }

    public static StreamedLoggerFactory init(File config, Callable<String> streamIdentifier) throws IOException {
        Properties props = new Properties();
        props.load(new FileReader(config));
        return new StreamedLoggerFactory(props, streamIdentifier);
    }

    public static StreamedLoggerFactory init(Properties props, Callable<String> streamIdentifier) {
        return new StreamedLoggerFactory(props, streamIdentifier);
    }

    public StreamedLoggerConfig config() {
        return this.config;
    }

    public synchronized Logger getLogger(String name) {
        if (this.loggers.containsKey(name)) {
            return this.loggers.get(name);
        }
        StreamedLogger ret = new StreamedLogger(this.config, name);
        this.loggers.put(name, ret);
        return ret;
    }

    public synchronized void setLevel(String logger, Level level) {
        this.config.setLevel(logger, level);
        if (this.loggers.containsKey(logger)) {
            this.loggers.get(logger).setLevel(level);
        }
    }

    public void defaultLevel(String logger, Level level) {
        if (!this.loggers.containsKey(logger)) {
            this.config.defaultLevel(logger, level);
        }
    }
}

