/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.streamedlogger;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.zinutils.streamedlogger.ReverseStringOrder;
import org.zinutils.streamedlogger.api.Config;
import org.zinutils.streamedlogger.api.Level;

public abstract class StreamedLoggerConfig
implements Config {
    protected boolean suppressAll;
    protected final boolean wantStreams;
    protected final Callable<String> streamIdentifier;
    protected Level defaultLevel;
    protected Map<String, Level> levels = new TreeMap<String, Level>(new ReverseStringOrder());

    public StreamedLoggerConfig(Properties props, Callable<String> streamIdentifier) {
        String wantStreams = props.getProperty("streamlogger.usestreams");
        this.wantStreams = !"false".equalsIgnoreCase(wantStreams);
        this.streamIdentifier = streamIdentifier;
        this.defaultLevel = Level.valueOf((String)props.getOrDefault((Object)"streamlogger.defaultLevel", "INFO"));
        for (Map.Entry<Object, Object> p : props.entrySet()) {
            String key = (String)p.getKey();
            if (!key.startsWith("streamlogger.levelOf.")) continue;
            String value = (String)p.getValue();
            this.levels.put(key.substring(21), Level.valueOf(value));
        }
    }

    @Override
    public Level level(String module) {
        for (Map.Entry<String, Level> p : this.levels.entrySet()) {
            String key = p.getKey();
            if (module.startsWith(key)) {
                return p.getValue();
            }
            if (module.compareTo(key) <= 0) continue;
            break;
        }
        return this.defaultLevel;
    }

    @Override
    public String call() throws Exception {
        if (this.streamIdentifier == null) {
            return null;
        }
        return this.streamIdentifier.call();
    }

    @Override
    public boolean isStreamed() {
        return this.wantStreams;
    }

    public void defaultLevel(String logger, Level level) {
        if (!this.levels.containsKey(logger)) {
            this.levels.put(logger, level);
        }
    }

    public void setLevel(String logger, Level level) {
        this.levels.put(logger, level);
    }

    @Override
    public boolean suppressAll() {
        return this.suppressAll;
    }

    public void suppress() {
        this.suppressAll = true;
    }
}

