/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.streamedlogger;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.zinutils.streamedlogger.Output;
import org.zinutils.streamedlogger.StreamLogItem;
import org.zinutils.streamedlogger.api.Config;
import org.zinutils.streamedlogger.api.Level;
import org.zinutils.streamedlogger.api.LogItem;

public class StreamedLogger
implements Logger {
    private final Config config;
    private final String module;
    private final Output output;
    private Level level;

    public StreamedLogger(Config config, String module) {
        this.config = config;
        this.module = module;
        this.output = new Output(config.isStreamed());
        this.level = config.level(module);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String toString() {
        return "Logger[" + this.module + ":" + this.level + "]";
    }

    public String getName() {
        return this.module;
    }

    public boolean isErrorEnabled() {
        return this.level.compareTo(Level.ERROR) >= 0;
    }

    public boolean isErrorEnabled(Marker m) {
        return this.level.compareTo(Level.ERROR) >= 0;
    }

    public boolean isWarnEnabled() {
        return this.level.compareTo(Level.WARN) >= 0;
    }

    public boolean isWarnEnabled(Marker m) {
        return this.level.compareTo(Level.WARN) >= 0;
    }

    public boolean isInfoEnabled() {
        return this.level.compareTo(Level.INFO) >= 0;
    }

    public boolean isInfoEnabled(Marker m) {
        return this.level.compareTo(Level.INFO) >= 0;
    }

    public boolean isDebugEnabled() {
        return this.level.compareTo(Level.DEBUG) >= 0;
    }

    public boolean isDebugEnabled(Marker m) {
        return this.level.compareTo(Level.DEBUG) >= 0;
    }

    public boolean isTraceEnabled() {
        return this.level.compareTo(Level.TRACE) >= 0;
    }

    public boolean isTraceEnabled(Marker m) {
        return this.level.compareTo(Level.TRACE) >= 0;
    }

    public void error(String msg) {
        this.process(this.item(Level.ERROR, null, msg, new Object[0]));
    }

    public void error(String format, Object arg1) {
        this.process(this.item(Level.ERROR, null, format, arg1));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.process(this.item(Level.ERROR, null, format, arg1, arg2));
    }

    public void error(String format, Object ... args) {
        this.process(this.item(Level.ERROR, null, format, args));
    }

    public void error(String format, Throwable arg1) {
        this.process(this.item(Level.ERROR, arg1, format, new Object[0]));
    }

    public void error(Marker m, String msg) {
        this.process(this.item(Level.ERROR, null, msg, new Object[0]));
    }

    public void error(Marker m, String format, Object arg1) {
        this.process(this.item(Level.ERROR, null, format, arg1));
    }

    public void error(Marker m, String format, Object arg1, Object arg2) {
        this.process(this.item(Level.ERROR, null, format, arg1, arg2));
    }

    public void error(Marker m, String format, Object ... args) {
        this.process(this.item(Level.ERROR, null, format, args));
    }

    public void error(Marker m, String format, Throwable arg1) {
        this.process(this.item(Level.ERROR, arg1, format, new Object[0]));
    }

    public void warn(String msg) {
        this.process(this.item(Level.WARN, null, msg, new Object[0]));
    }

    public void warn(String format, Object arg1) {
        this.process(this.item(Level.WARN, null, format, arg1));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.process(this.item(Level.WARN, null, format, arg1, arg2));
    }

    public void warn(String format, Object ... args) {
        this.process(this.item(Level.WARN, null, format, args));
    }

    public void warn(String format, Throwable arg1) {
        this.process(this.item(Level.WARN, arg1, format, new Object[0]));
    }

    public void warn(Marker m, String msg) {
        this.process(this.item(Level.WARN, null, msg, new Object[0]));
    }

    public void warn(Marker m, String format, Object arg1) {
        this.process(this.item(Level.WARN, null, format, arg1));
    }

    public void warn(Marker m, String format, Object arg1, Object arg2) {
        this.process(this.item(Level.WARN, null, format, arg1, arg2));
    }

    public void warn(Marker m, String format, Object ... args) {
        this.process(this.item(Level.WARN, null, format, args));
    }

    public void warn(Marker m, String format, Throwable arg1) {
        this.process(this.item(Level.WARN, arg1, format, new Object[0]));
    }

    public void info(String msg) {
        this.process(this.item(Level.INFO, null, msg, new Object[0]));
    }

    public void info(String format, Object arg1) {
        this.process(this.item(Level.INFO, null, format, arg1));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.process(this.item(Level.INFO, null, format, arg1, arg2));
    }

    public void info(String format, Object ... args) {
        this.process(this.item(Level.INFO, null, format, args));
    }

    public void info(String format, Throwable arg1) {
        this.process(this.item(Level.INFO, arg1, format, new Object[0]));
    }

    public void info(Marker m, String msg) {
        this.process(this.item(Level.INFO, null, msg, new Object[0]));
    }

    public void info(Marker m, String format, Object arg1) {
        this.process(this.item(Level.INFO, null, format, arg1));
    }

    public void info(Marker m, String format, Object arg1, Object arg2) {
        this.process(this.item(Level.INFO, null, format, arg1, arg2));
    }

    public void info(Marker m, String format, Object ... args) {
        this.process(this.item(Level.INFO, null, format, args));
    }

    public void info(Marker m, String format, Throwable arg1) {
        this.process(this.item(Level.INFO, arg1, format, new Object[0]));
    }

    public void debug(String msg) {
        this.process(this.item(Level.DEBUG, null, msg, new Object[0]));
    }

    public void debug(String format, Object arg1) {
        this.process(this.item(Level.DEBUG, null, format, arg1));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.process(this.item(Level.DEBUG, null, format, arg1, arg2));
    }

    public void debug(String format, Object ... args) {
        this.process(this.item(Level.DEBUG, null, format, args));
    }

    public void debug(String format, Throwable arg1) {
        this.process(this.item(Level.DEBUG, arg1, format, new Object[0]));
    }

    public void debug(Marker m, String msg) {
        this.process(this.item(Level.DEBUG, null, msg, new Object[0]));
    }

    public void debug(Marker m, String format, Object arg1) {
        this.process(this.item(Level.DEBUG, null, format, arg1));
    }

    public void debug(Marker m, String format, Object arg1, Object arg2) {
        this.process(this.item(Level.DEBUG, null, format, arg1, arg2));
    }

    public void debug(Marker m, String format, Object ... args) {
        this.process(this.item(Level.DEBUG, null, format, args));
    }

    public void debug(Marker m, String format, Throwable arg1) {
        this.process(this.item(Level.DEBUG, arg1, format, new Object[0]));
    }

    public void trace(String msg) {
        this.process(this.item(Level.TRACE, null, msg, new Object[0]));
    }

    public void trace(String format, Object arg1) {
        this.process(this.item(Level.TRACE, null, format, arg1));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.process(this.item(Level.TRACE, null, format, arg1, arg2));
    }

    public void trace(String format, Object ... args) {
        this.process(this.item(Level.TRACE, null, format, args));
    }

    public void trace(String format, Throwable arg1) {
        this.process(this.item(Level.TRACE, arg1, format, new Object[0]));
    }

    public void trace(Marker m, String msg) {
        this.process(this.item(Level.TRACE, null, msg, new Object[0]));
    }

    public void trace(Marker m, String format, Object arg1) {
        this.process(this.item(Level.TRACE, null, format, arg1));
    }

    public void trace(Marker m, String format, Object arg1, Object arg2) {
        this.process(this.item(Level.TRACE, null, format, arg1, arg2));
    }

    public void trace(Marker m, String format, Object ... args) {
        this.process(this.item(Level.TRACE, null, format, args));
    }

    public void trace(Marker m, String format, Throwable arg1) {
        this.process(this.item(Level.TRACE, arg1, format, new Object[0]));
    }

    private LogItem item(Level level, Throwable t, String format, Object ... args) {
        if (level.isNotAsSeriousAs(this.level)) {
            return null;
        }
        String stream = null;
        try {
            stream = (String)this.config.call();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new StreamLogItem(stream, this.module, level, t, format, args);
    }

    private void process(LogItem item) {
        if (item == null || this.config.suppressAll()) {
            return;
        }
        Consumer<String> sink = this.config.streamSink(item.streamName());
        this.output.format(item, sink);
    }
}

