/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.streamedlogger;

import java.util.Date;
import org.slf4j.helpers.MessageFormatter;
import org.zinutils.streamedlogger.api.Level;
import org.zinutils.streamedlogger.api.LogItem;

public class StreamLogItem
implements LogItem {
    private final Date when;
    private final String streamName;
    private final String module;
    private final Level level;
    private final String threadName;
    private final String format;
    private final Object[] args;
    private final Throwable t;

    public StreamLogItem(String streamName, String module, Level level, Throwable t, String format, Object[] args) {
        this.streamName = streamName;
        this.when = new Date();
        this.module = module;
        this.level = level;
        this.threadName = Thread.currentThread().getName();
        this.format = format;
        this.args = args;
        this.t = t;
    }

    @Override
    public Date when() {
        return this.when;
    }

    @Override
    public String streamName() {
        return this.streamName;
    }

    @Override
    public String module() {
        return this.module;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public Throwable getThrowable() {
        return this.t;
    }

    @Override
    public String threadName() {
        return this.threadName;
    }

    @Override
    public String message() {
        if (this.args != null && this.args.length > 0) {
            return MessageFormatter.arrayFormat((String)this.format, (Object[])this.args).getMessage();
        }
        return this.format;
    }
}

