/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.streamedlogger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.zinutils.streamedlogger.api.LogItem;

public class Output {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
    private static final int maxNameLength = 18;
    private boolean isStreamed;

    public Output(boolean isStreamed) {
        this.isStreamed = isStreamed;
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void format(LogItem item, Consumer<String> sink) {
        String stream;
        Object name = item.module();
        if (((String)name).length() < 18) {
            name = "                  " + (String)name;
        }
        name = ((String)name).substring(((String)name).length() - 18);
        String exInfo = "";
        Throwable ex = item.getThrowable();
        if (ex != null) {
            StringWriter ew = new StringWriter();
            PrintWriter w = new PrintWriter(ew);
            ex.printStackTrace(w);
            exInfo = ew.toString();
        }
        String msg = this.sdf.format(item.when()) + " " + (String)name + "/" + item.threadName() + " " + item.level() + ": " + item.message() + "\n" + exInfo;
        if (!this.isStreamed && (stream = item.streamName()) != null) {
            msg = stream + " " + msg;
        }
        sink.accept(msg);
    }
}

