/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Properties;
import org.slf4j.ILoggerFactory;
import org.zinutils.streamedlogger.StreamedLoggerFactory;
import org.zinutils.streamedlogger.api.Level;

public class StaticLoggerBinder {
    private static Properties consoleProps = System.getProperties();
    private final StreamedLoggerFactory mlf;

    public StaticLoggerBinder(StreamedLoggerFactory mlf) {
        this.mlf = mlf;
    }

    public static StaticLoggerBinder getSingleton() {
        if (StreamedLoggerFactory.binder == null) {
            StreamedLoggerFactory.init(consoleProps, null);
        }
        return StreamedLoggerFactory.binder;
    }

    public String getLoggerFactoryClassStr() {
        return StreamedLoggerFactory.class.getName();
    }

    public ILoggerFactory getLoggerFactory() {
        return this.mlf;
    }

    public static void setLevel(String logger, Level level) {
        StaticLoggerBinder.getSingleton().mlf.setLevel(logger, level);
    }

    public static void defaultLevel(String logger, Level level) {
        StaticLoggerBinder.getSingleton().mlf.defaultLevel(logger, level);
    }

    public static void suppress() {
        StaticLoggerBinder.getSingleton().mlf.config().suppress();
    }
}

