/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.ConnectTo;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.ZiwshClientSocket;
import org.zinutils.exceptions.NotImplementedException;

public class ZiwshWebClient
implements WSResponder {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiWSH");
    private final ZiwshClientSocket conn;
    private final List<String> queue = new ArrayList<String>();
    private boolean connected = false;

    public ZiwshWebClient(ZiwshBroker zb, ConnectTo uri, SSLEngineConfigurator sslConfig) {
        this.conn = new ZiwshClientSocket(this, uri, sslConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionProtocol() {
        this.conn.connect();
        ZiwshWebClient ziwshWebClient = this;
        synchronized (ziwshWebClient) {
            this.conn.send("{\"action\":\"greetings\"}");
            try {
                this.wait(2500L);
            }
            catch (InterruptedException e) {
                logger.info("interrupted");
            }
        }
        if (!this.connected) {
            throw new RuntimeException("we are not connected");
        }
    }

    public void attachBeachhead(Beachhead server) {
        this.conn.attachBeachhead(server);
    }

    public synchronized void send(String json) {
        if (this.connected && this.conn.isConnected() && this.queue.isEmpty()) {
            logger.debug("zwc sending " + json);
            this.conn.send(json);
        } else {
            logger.debug("zwc queueing " + json + " to send when connected");
            this.queue.add(json);
        }
    }

    public synchronized void onConnectionAccepted() {
        this.connected = true;
        logger.debug("connection accepted");
        while (this.conn.isConnected() && !this.queue.isEmpty()) {
            String json = this.queue.remove(0);
            logger.debug("sending queued " + json);
            this.conn.send(json);
        }
        this.notifyAll();
    }

    public synchronized boolean isOpen() {
        if (!this.conn.isConnected()) {
            return false;
        }
        if (this.connected) {
            return true;
        }
        try {
            this.wait(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.conn.isConnected() && this.connected;
    }

    public synchronized void disconnect() {
        logger.debug("disconnecting");
        this.conn.close(1000, "invalid token");
        this.connected = false;
        this.notifyAll();
    }

    public synchronized void onClose() {
        this.connected = false;
        this.conn.setClosed();
        this.notifyAll();
    }

    public void setDessication(String token) {
        throw new NotImplementedException();
    }

    public String dessicated() {
        throw new NotImplementedException();
    }

    public URI connectionName() {
        throw new NotImplementedException();
    }

    public void close(String reason) {
        throw new NotImplementedException();
    }
}

