/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketClientFilter;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.ConnectTo;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.jvm.ClientSideConnectionHandler;
import org.ziniki.ziwsh.jvm.ZiWSHProtocolHandler;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.WrappedException;

public class ZiwshClientSocket
extends SimpleWebSocket {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiWSH");
    private final ConnectTo address;
    private final ClientSideConnectionHandler handler;
    private TCPNIOTransport transport;
    private final SSLEngineConfigurator sslConfig;

    public ZiwshClientSocket(WSResponder replyTo, ConnectTo uri, SSLEngineConfigurator sslConfig) {
        super(ZiwshClientSocket.createProtocolHandler(uri.token(), uri.secret()), new WebSocketListener[0]);
        logger.info("creating a connection to " + uri);
        this.address = uri;
        this.sslConfig = sslConfig;
        this.handler = new ClientSideConnectionHandler(replyTo);
        this.add((WebSocketListener)this.handler);
        logger.info("listeners = " + this.getListeners());
    }

    private static ProtocolHandler createProtocolHandler(String token, String secret) {
        return new ZiWSHProtocolHandler(true, token, secret);
    }

    public void connect() {
        try {
            this.transport = TCPNIOTransportBuilder.newInstance().build();
            this.transport.start();
            logger.debug("transport is blocking = " + this.transport.isBlocking());
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

                protected void preConfigure(Connection conn) {
                    logger.info("in preconfigure, configuring " + ZiwshClientSocket.this.address);
                    super.preConfigure(conn);
                    ZiwshClientSocket.this.protocolHandler.setConnection(conn);
                    WebSocketHolder holder = WebSocketHolder.set((Connection)conn, (ProtocolHandler)ZiwshClientSocket.this.protocolHandler, (WebSocket)ZiwshClientSocket.this);
                    holder.handshake = ZiwshClientSocket.this.protocolHandler.createClientHandShake(ZiwshClientSocket.this.address.getURI());
                }
            };
            connectorHandler.setProcessor(this.createFilterChain());
            int port = this.address.getURI().getPort();
            if (port == -1) {
                port = this.address.getURI().getScheme().equals("wss") ? 443 : 80;
            }
            logger.debug("attempting to connect for 5s ...");
            connectorHandler.connect((SocketAddress)new InetSocketAddress(this.address.getURI().getHost(), port), (CompletionHandler)this.handler);
            this.handler.await(5, TimeUnit.SECONDS);
            logger.debug("connected");
        }
        catch (Throwable e) {
            logger.info("error connecting: client socket state = " + this.state.get(), WrappedException.unwrapThrowable((Throwable)e));
            e = WrappedException.unwrapThrowable((Throwable)e);
            if (e instanceof HandshakeException || e instanceof UnresolvedAddressException) {
                logger.info("Could not connect to " + this.address);
                throw new CantHappenException("cannot connect to " + this.address);
            }
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public void attachBeachhead(Beachhead server) {
        this.handler.attachBeachhead(server);
    }

    Processor createFilterChain() throws Exception {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        if (this.sslConfig != null) {
            this.configureSSL(clientFilterChainBuilder);
        }
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new WebSocketClientFilter(){

            protected void onHandshakeFailure(Connection connection, HandshakeException e) {
                logger.error("handshake failed", (Throwable)e);
            }
        });
        return clientFilterChainBuilder.build();
    }

    private void configureSSL(FilterChainBuilder clientFilterChainBuilder) {
        SSLFilter sslFilter = new SSLFilter(null, this.sslConfig);
        clientFilterChainBuilder.add((Filter)sslFilter);
        sslFilter.addHandshakeListener(new SSLBaseFilter.HandshakeListener(){

            public void onStart(Connection arg0) {
            }

            public void onFailure(Connection arg0, Throwable arg1) {
                logger.info("failed handshake");
                arg1.printStackTrace();
                ZiwshClientSocket.this.handler.failed(arg1);
            }

            public void onComplete(Connection arg0) {
            }
        });
    }
}

