/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.net.URI;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.rfc6455.RFC6455HandShake;
import org.zinutils.exceptions.CantHappenException;

public class ZiWSHSecretHandshake
extends RFC6455HandShake {
    private final String token;
    private final String secret;

    public ZiWSHSecretHandshake(URI uri, String token, String secret) {
        super(uri);
        this.token = token;
        this.secret = secret;
    }

    public HttpContent composeHeaders() {
        HttpContent content = super.composeHeaders();
        HttpHeader header = content.getHttpHeader();
        header.addHeader("X-ZINIKI-TOKEN", this.token);
        header.addHeader("X-ZINIKI-SECRET", this.secret);
        return content;
    }

    public void validateServerResponse(HttpResponsePacket headers) throws HandshakeException {
        if (headers.getStatus() == 403) {
            throw new CantHappenException("connection to " + this.getLocation() + " refused.  Token/secret probably invalid");
        }
        super.validateServerResponse(headers);
    }
}

